/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PBMAC1Params;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.jcajce.io.MacOutputStream;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.operator.DefaultMacAlgorithmIdentifierFinder;
import net.savignano.thirdparty.org.bouncycastle.operator.GenericKey;
import net.savignano.thirdparty.org.bouncycastle.operator.MacAlgorithmIdentifierFinder;
import net.savignano.thirdparty.org.bouncycastle.operator.MacCalculator;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

public class JcePBMac1CalculatorBuilder {
    public static final AlgorithmIdentifier PRF_SHA224 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA224, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA256 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA384 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA384, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA512 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA3_224 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_224);
    public static final AlgorithmIdentifier PRF_SHA3_256 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_256);
    public static final AlgorithmIdentifier PRF_SHA3_384 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_384);
    public static final AlgorithmIdentifier PRF_SHA3_512 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512);
    private static final DefaultMacAlgorithmIdentifierFinder defaultFinder = new DefaultMacAlgorithmIdentifierFinder();
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private AlgorithmIdentifier macAlgorithm;
    private SecureRandom random;
    private int saltLength = -1;
    private int iterationCount = 8192;
    private int keySize;
    private PBKDF2Params pbeParams = null;
    private AlgorithmIdentifier prf = PRF_SHA256;
    private byte[] salt = null;

    public JcePBMac1CalculatorBuilder(String macAlgorithm, int keySize) {
        this(macAlgorithm, keySize, defaultFinder);
    }

    public JcePBMac1CalculatorBuilder(String macAlgorithm, int keySize, MacAlgorithmIdentifierFinder algIdFinder) {
        this.macAlgorithm = algIdFinder.find(macAlgorithm);
        this.keySize = keySize;
    }

    public JcePBMac1CalculatorBuilder(PBMAC1Params pbeMacParams) {
        this.macAlgorithm = pbeMacParams.getMessageAuthScheme();
        this.pbeParams = PBKDF2Params.getInstance(pbeMacParams.getKeyDerivationFunc().getParameters());
    }

    public JcePBMac1CalculatorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePBMac1CalculatorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    JcePBMac1CalculatorBuilder setHelper(JcaJceHelper helper) {
        this.helper = helper;
        return this;
    }

    public JcePBMac1CalculatorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    public JcePBMac1CalculatorBuilder setSaltLength(int saltLength) {
        this.saltLength = saltLength;
        return this;
    }

    public JcePBMac1CalculatorBuilder setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public JcePBMac1CalculatorBuilder setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JcePBMac1CalculatorBuilder setPrf(AlgorithmIdentifier prf) {
        this.prf = prf;
        return this;
    }

    public MacCalculator build(char[] password) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            final Mac mac = this.helper.createMac(this.macAlgorithm.getAlgorithm().getId());
            if (this.pbeParams == null) {
                if (this.salt == null) {
                    if (this.saltLength < 0) {
                        this.saltLength = mac.getMacLength();
                    }
                    this.salt = new byte[this.saltLength];
                    this.random.nextBytes(this.salt);
                }
            } else {
                this.salt = this.pbeParams.getSalt();
                this.iterationCount = BigIntegers.intValueExact(this.pbeParams.getIterationCount());
                this.keySize = BigIntegers.intValueExact(this.pbeParams.getKeyLength()) * 8;
            }
            SecretKeyFactory secFact = this.helper.createSecretKeyFactory("PBKDF2");
            final SecretKey key = secFact.generateSecret(new PBKDF2KeySpec(password, this.salt, this.iterationCount, this.keySize, this.prf));
            mac.init(key);
            return new MacCalculator(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBMAC1, new PBMAC1Params(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, new PBKDF2Params(JcePBMac1CalculatorBuilder.this.salt, JcePBMac1CalculatorBuilder.this.iterationCount, (JcePBMac1CalculatorBuilder.this.keySize + 7) / 8, JcePBMac1CalculatorBuilder.this.prf)), JcePBMac1CalculatorBuilder.this.macAlgorithm));
                }

                public OutputStream getOutputStream() {
                    return new MacOutputStream(mac);
                }

                public byte[] getMac() {
                    return mac.doFinal();
                }

                public GenericKey getKey() {
                    return new GenericKey(this.getAlgorithmIdentifier(), key.getEncoded());
                }
            };
        }
        catch (Exception e) {
            throw new OperatorCreationException("unable to create MAC calculator: " + e.getMessage(), e);
        }
    }
}

