/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.asn1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class CMCEPublicKey
extends ASN1Object {
    private byte[] T;

    public CMCEPublicKey(byte[] t) {
        this.T = t;
    }

    public CMCEPublicKey(ASN1Sequence seq) {
        this.T = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
    }

    public byte[] getT() {
        return Arrays.clone(this.T);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DEROctetString(this.T));
        return new DERSequence(v);
    }

    public static CMCEPublicKey getInstance(Object o) {
        if (o instanceof CMCEPublicKey) {
            return (CMCEPublicKey)o;
        }
        if (o != null) {
            return new CMCEPublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

