/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHAKEDigest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.Packing;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.Poly;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecK;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecL;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecMatrix;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.Symmetric;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class DilithiumEngine {
    private final SecureRandom random;
    private final SHAKEDigest shake128Digest = new SHAKEDigest(128);
    private final SHAKEDigest shake256Digest = new SHAKEDigest(256);
    public static final int DilithiumN = 256;
    public static final int DilithiumQ = 8380417;
    public static final int DilithiumQinv = 58728449;
    public static final int DilithiumD = 13;
    public static final int DilithiumRootOfUnity = 1753;
    public static final int SeedBytes = 32;
    public static final int CrhBytes = 64;
    public static final int DilithiumPolyT1PackedBytes = 320;
    public static final int DilithiumPolyT0PackedBytes = 416;
    private final int DilithiumPolyVecHPackedBytes;
    private final int DilithiumPolyZPackedBytes;
    private final int DilithiumPolyW1PackedBytes;
    private final int DilithiumPolyEtaPackedBytes;
    private final int DilithiumMode;
    private final int DilithiumK;
    private final int DilithiumL;
    private final int DilithiumEta;
    private final int DilithiumTau;
    private final int DilithiumBeta;
    private final int DilithiumGamma1;
    private final int DilithiumGamma2;
    private final int DilithiumOmega;
    private final int CryptoPublicKeyBytes;
    private final int CryptoSecretKeyBytes;
    private final int CryptoBytes;
    private final int PolyUniformGamma1NBlocks;
    private final Symmetric symmetric;

    protected Symmetric GetSymmetric() {
        return this.symmetric;
    }

    public int getDilithiumPolyVecHPackedBytes() {
        return this.DilithiumPolyVecHPackedBytes;
    }

    public int getDilithiumPolyZPackedBytes() {
        return this.DilithiumPolyZPackedBytes;
    }

    public int getDilithiumPolyW1PackedBytes() {
        return this.DilithiumPolyW1PackedBytes;
    }

    public int getDilithiumPolyEtaPackedBytes() {
        return this.DilithiumPolyEtaPackedBytes;
    }

    public int getDilithiumMode() {
        return this.DilithiumMode;
    }

    public int getDilithiumK() {
        return this.DilithiumK;
    }

    public int getDilithiumL() {
        return this.DilithiumL;
    }

    public int getDilithiumEta() {
        return this.DilithiumEta;
    }

    public int getDilithiumTau() {
        return this.DilithiumTau;
    }

    public int getDilithiumBeta() {
        return this.DilithiumBeta;
    }

    public int getDilithiumGamma1() {
        return this.DilithiumGamma1;
    }

    public int getDilithiumGamma2() {
        return this.DilithiumGamma2;
    }

    public int getDilithiumOmega() {
        return this.DilithiumOmega;
    }

    public int getCryptoPublicKeyBytes() {
        return this.CryptoPublicKeyBytes;
    }

    public int getCryptoSecretKeyBytes() {
        return this.CryptoSecretKeyBytes;
    }

    public int getCryptoBytes() {
        return this.CryptoBytes;
    }

    public int getPolyUniformGamma1NBlocks() {
        return this.PolyUniformGamma1NBlocks;
    }

    public SHAKEDigest getShake256Digest() {
        return this.shake256Digest;
    }

    public SHAKEDigest getShake128Digest() {
        return this.shake128Digest;
    }

    public DilithiumEngine(int mode, SecureRandom random, boolean usingAes) {
        this.DilithiumMode = mode;
        switch (mode) {
            case 2: {
                this.DilithiumK = 4;
                this.DilithiumL = 4;
                this.DilithiumEta = 2;
                this.DilithiumTau = 39;
                this.DilithiumBeta = 78;
                this.DilithiumGamma1 = 131072;
                this.DilithiumGamma2 = 95232;
                this.DilithiumOmega = 80;
                this.DilithiumPolyZPackedBytes = 576;
                this.DilithiumPolyW1PackedBytes = 192;
                this.DilithiumPolyEtaPackedBytes = 96;
                break;
            }
            case 3: {
                this.DilithiumK = 6;
                this.DilithiumL = 5;
                this.DilithiumEta = 4;
                this.DilithiumTau = 49;
                this.DilithiumBeta = 196;
                this.DilithiumGamma1 = 524288;
                this.DilithiumGamma2 = 261888;
                this.DilithiumOmega = 55;
                this.DilithiumPolyZPackedBytes = 640;
                this.DilithiumPolyW1PackedBytes = 128;
                this.DilithiumPolyEtaPackedBytes = 128;
                break;
            }
            case 5: {
                this.DilithiumK = 8;
                this.DilithiumL = 7;
                this.DilithiumEta = 2;
                this.DilithiumTau = 60;
                this.DilithiumBeta = 120;
                this.DilithiumGamma1 = 524288;
                this.DilithiumGamma2 = 261888;
                this.DilithiumOmega = 75;
                this.DilithiumPolyZPackedBytes = 640;
                this.DilithiumPolyW1PackedBytes = 128;
                this.DilithiumPolyEtaPackedBytes = 96;
                break;
            }
            default: {
                throw new IllegalArgumentException("The mode " + mode + "is not supported by Crystals Dilithium!");
            }
        }
        this.symmetric = usingAes ? new Symmetric.AesSymmetric() : new Symmetric.ShakeSymmetric();
        this.random = random;
        this.DilithiumPolyVecHPackedBytes = this.DilithiumOmega + this.DilithiumK;
        this.CryptoPublicKeyBytes = 32 + this.DilithiumK * 320;
        this.CryptoSecretKeyBytes = 96 + this.DilithiumL * this.DilithiumPolyEtaPackedBytes + this.DilithiumK * this.DilithiumPolyEtaPackedBytes + this.DilithiumK * 416;
        this.CryptoBytes = 32 + this.DilithiumL * this.DilithiumPolyZPackedBytes + this.DilithiumPolyVecHPackedBytes;
        if (this.DilithiumGamma1 == 131072) {
            this.PolyUniformGamma1NBlocks = (576 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else if (this.DilithiumGamma1 == 524288) {
            this.PolyUniformGamma1NBlocks = (640 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else {
            throw new RuntimeException("Wrong Dilithium Gamma1!");
        }
    }

    public byte[][] generateKeyPair() {
        byte[] seedBuf = new byte[32];
        byte[] buf = new byte[128];
        byte[] tr = new byte[32];
        byte[] rho = new byte[32];
        byte[] rhoPrime = new byte[64];
        byte[] key = new byte[32];
        PolyVecMatrix aMatrix = new PolyVecMatrix(this);
        PolyVecL s1 = new PolyVecL(this);
        PolyVecK s2 = new PolyVecK(this);
        PolyVecK t1 = new PolyVecK(this);
        PolyVecK t0 = new PolyVecK(this);
        this.random.nextBytes(seedBuf);
        this.shake256Digest.update(seedBuf, 0, 32);
        this.shake256Digest.doFinal(buf, 0, 128);
        System.arraycopy(buf, 0, rho, 0, 32);
        System.arraycopy(buf, 32, rhoPrime, 0, 64);
        System.arraycopy(buf, 96, key, 0, 32);
        aMatrix.expandMatrix(rho);
        s1.uniformEta(rhoPrime, (short)0);
        s2.uniformEta(rhoPrime, (short)this.DilithiumL);
        PolyVecL s1hat = new PolyVecL(this);
        s1.copyPolyVecL(s1hat);
        s1hat.polyVecNtt();
        aMatrix.pointwiseMontgomery(t1, s1hat);
        t1.reduce();
        t1.invNttToMont();
        t1.addPolyVecK(s2);
        t1.conditionalAddQ();
        t1.power2Round(t0);
        byte[] encT1 = Packing.packPublicKey(t1, this);
        this.shake256Digest.update(rho, 0, rho.length);
        this.shake256Digest.update(encT1, 0, encT1.length);
        this.shake256Digest.doFinal(tr, 0, 32);
        byte[][] sk = Packing.packSecretKey(rho, tr, key, t0, s1, s2, this);
        return new byte[][]{sk[0], sk[1], sk[2], sk[3], sk[4], sk[5], encT1};
    }

    public byte[] signSignature(byte[] msg, int msglen, byte[] rho, byte[] key, byte[] tr, byte[] t0Enc, byte[] s1Enc, byte[] s2Enc) {
        byte[] outSig = new byte[this.CryptoBytes + msglen];
        byte[] mu = new byte[64];
        byte[] rhoPrime = new byte[64];
        short nonce = 0;
        PolyVecL s1 = new PolyVecL(this);
        PolyVecL y = new PolyVecL(this);
        PolyVecL z = new PolyVecL(this);
        PolyVecK t0 = new PolyVecK(this);
        PolyVecK s2 = new PolyVecK(this);
        PolyVecK w1 = new PolyVecK(this);
        PolyVecK w0 = new PolyVecK(this);
        PolyVecK h = new PolyVecK(this);
        Poly cp = new Poly(this);
        PolyVecMatrix aMatrix = new PolyVecMatrix(this);
        Packing.unpackSecretKey(t0, s1, s2, t0Enc, s1Enc, s2Enc, this);
        this.shake256Digest.update(tr, 0, 32);
        this.shake256Digest.update(msg, 0, msglen);
        this.shake256Digest.doFinal(mu, 0, 64);
        if (this.random != null) {
            this.random.nextBytes(rhoPrime);
        } else {
            byte[] keyMu = Arrays.copyOf(key, 96);
            System.arraycopy(mu, 0, keyMu, 32, 64);
            this.shake256Digest.update(keyMu, 0, 96);
            this.shake256Digest.doFinal(rhoPrime, 0, 64);
        }
        aMatrix.expandMatrix(rho);
        s1.polyVecNtt();
        s2.polyVecNtt();
        t0.polyVecNtt();
        int count = 0;
        while (count < 1000) {
            ++count;
            short s = nonce;
            nonce = (short)(nonce + 1);
            y.uniformGamma1(rhoPrime, s);
            y.copyPolyVecL(z);
            z.polyVecNtt();
            aMatrix.pointwiseMontgomery(w1, z);
            w1.reduce();
            w1.invNttToMont();
            w1.conditionalAddQ();
            w1.decompose(w0);
            System.arraycopy(w1.packW1(), 0, outSig, 0, this.DilithiumK * this.DilithiumPolyW1PackedBytes);
            this.shake256Digest.update(mu, 0, 64);
            this.shake256Digest.update(outSig, 0, this.DilithiumK * this.DilithiumPolyW1PackedBytes);
            this.shake256Digest.doFinal(outSig, 0, 32);
            cp.challenge(Arrays.copyOfRange(outSig, 0, 32));
            cp.polyNtt();
            z.pointwisePolyMontgomery(cp, s1);
            z.invNttToMont();
            z.addPolyVecL(y);
            z.reduce();
            if (z.checkNorm(this.DilithiumGamma1 - this.DilithiumBeta)) continue;
            h.pointwisePolyMontgomery(cp, s2);
            h.invNttToMont();
            w0.subtract(h);
            w0.reduce();
            if (w0.checkNorm(this.DilithiumGamma2 - this.DilithiumBeta)) continue;
            h.pointwisePolyMontgomery(cp, t0);
            h.invNttToMont();
            h.reduce();
            if (h.checkNorm(this.DilithiumGamma2)) continue;
            w0.addPolyVecK(h);
            w0.conditionalAddQ();
            int n = h.makeHint(w0, w1);
            if (n > this.DilithiumOmega) continue;
            return Packing.packSignature(outSig, z, h, this);
        }
        return null;
    }

    public byte[] sign(byte[] msg, int mlen, byte[] rho, byte[] key, byte[] tr, byte[] t0, byte[] s1, byte[] s2) {
        return this.signSignature(msg, mlen, rho, key, tr, t0, s1, s2);
    }

    public boolean signVerify(byte[] sig, int siglen, byte[] msg, int msglen, byte[] rho, byte[] encT1) {
        byte[] mu = new byte[64];
        byte[] c2 = new byte[32];
        Poly cp = new Poly(this);
        PolyVecMatrix aMatrix = new PolyVecMatrix(this);
        PolyVecL z = new PolyVecL(this);
        PolyVecK t1 = new PolyVecK(this);
        PolyVecK w1 = new PolyVecK(this);
        PolyVecK h = new PolyVecK(this);
        if (siglen != this.CryptoBytes) {
            return false;
        }
        t1 = Packing.unpackPublicKey(t1, encT1, this);
        if (!Packing.unpackSignature(z, h, sig, this)) {
            return false;
        }
        byte[] c = Arrays.copyOfRange(sig, 0, 32);
        if (z.checkNorm(this.getDilithiumGamma1() - this.getDilithiumBeta())) {
            return false;
        }
        this.shake256Digest.update(rho, 0, rho.length);
        this.shake256Digest.update(encT1, 0, encT1.length);
        this.shake256Digest.doFinal(mu, 0, 32);
        this.shake256Digest.update(mu, 0, 32);
        this.shake256Digest.update(msg, 0, msglen);
        this.shake256Digest.doFinal(mu, 0);
        cp.challenge(c);
        aMatrix.expandMatrix(rho);
        z.polyVecNtt();
        aMatrix.pointwiseMontgomery(w1, z);
        cp.polyNtt();
        t1.shiftLeft();
        t1.polyVecNtt();
        t1.pointwisePolyMontgomery(cp, t1);
        w1.subtract(t1);
        w1.reduce();
        w1.invNttToMont();
        w1.conditionalAddQ();
        w1.useHint(w1, h);
        byte[] buf = w1.packW1();
        SHAKEDigest shakeDigest256 = new SHAKEDigest(256);
        shakeDigest256.update(mu, 0, 64);
        shakeDigest256.update(buf, 0, this.DilithiumK * this.DilithiumPolyW1PackedBytes);
        shakeDigest256.doFinal(c2, 0, 32);
        for (int i = 0; i < 32; ++i) {
            if (c[i] == c2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean signOpen(byte[] msg, byte[] signedMsg, int signedMsglen, byte[] rho, byte[] t1) {
        return this.signVerify(signedMsg, signedMsglen, msg, msg.length, rho, t1);
    }
}

