/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.gemss;

import java.security.SecureRandom;
import java.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.gemss.GeMSSUtils;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.gemss.PointerUnion;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

class Pointer {
    protected long[] array;
    protected int cp;

    public Pointer() {
        this.cp = 0;
    }

    public Pointer(int len) {
        this.array = new long[len];
        this.cp = 0;
    }

    public Pointer(Pointer pointer) {
        this.array = pointer.array;
        this.cp = pointer.cp;
    }

    public Pointer(Pointer pointer, int shift) {
        this.array = pointer.array;
        this.cp = pointer.cp + shift;
    }

    public long get(int p) {
        return this.array[this.cp + p];
    }

    public long get() {
        return this.array[this.cp];
    }

    public void set(int p, long v) {
        this.array[this.cp + p] = v;
    }

    public void set(long v) {
        this.array[this.cp] = v;
    }

    public void setXor(int p, long v) {
        int n = this.cp + p;
        this.array[n] = this.array[n] ^ v;
    }

    public void setXor(long v) {
        int n = this.cp;
        this.array[n] = this.array[n] ^ v;
    }

    public void setXorRange(Pointer p, int len) {
        int outOff = this.cp;
        int inOff = p.cp;
        for (int i = 0; i < len; ++i) {
            int n = outOff++;
            this.array[n] = this.array[n] ^ p.array[inOff++];
        }
    }

    public void setXorRange(Pointer p, int inOff, int len) {
        int outOff = this.cp;
        inOff += p.cp;
        for (int i = 0; i < len; ++i) {
            int n = outOff++;
            this.array[n] = this.array[n] ^ p.array[inOff++];
        }
    }

    public void setXorRange(int outOff, Pointer p, int inOff, int len) {
        outOff += this.cp;
        inOff += p.cp;
        for (int i = 0; i < len; ++i) {
            int n = outOff++;
            this.array[n] = this.array[n] ^ p.array[inOff++];
        }
    }

    public void setXorRange_SelfMove(Pointer p, int len) {
        int inOff = p.cp;
        for (int i = 0; i < len; ++i) {
            int n = this.cp++;
            this.array[n] = this.array[n] ^ p.array[inOff++];
        }
    }

    public void setXorMatrix_NoMove(Pointer p, int len1, int len2) {
        int outOff = this.cp;
        for (int i = 0; i < len2; ++i) {
            int pos = outOff;
            for (int j = 0; j < len1; ++j) {
                int n = pos++;
                this.array[n] = this.array[n] ^ p.array[p.cp++];
            }
        }
    }

    public void setXorMatrix(Pointer p, int len1, int len2) {
        int outOff = this.cp;
        for (int i = 0; i < len2; ++i) {
            int pos = outOff;
            for (int j = 0; j < len1; ++j) {
                int n = pos++;
                this.array[n] = this.array[n] ^ p.array[p.cp++];
            }
        }
        this.cp += len1;
    }

    public void setXorRangeXor(int outOff, Pointer a, int a_cp, Pointer b, int b_cp, int len) {
        outOff += this.cp;
        a_cp += a.cp;
        b_cp += b.cp;
        for (int i = 0; i < len; ++i) {
            int n = outOff++;
            this.array[n] = this.array[n] ^ (a.array[a_cp++] ^ b.array[b_cp++]);
        }
    }

    public void setXorRange(int outOff, PointerUnion p, int inOff, int len) {
        outOff += this.cp;
        inOff += p.cp;
        if (p.remainder == 0) {
            for (int i = 0; i < len; ++i) {
                int n = outOff++;
                this.array[n] = this.array[n] ^ p.array[inOff++];
            }
        } else {
            int right = p.remainder << 3;
            int left = 8 - p.remainder << 3;
            for (int i = 0; i < len; ++i) {
                int n = outOff++;
                this.array[n] = this.array[n] ^ (p.array[inOff] >>> right | p.array[++inOff] << left);
            }
        }
    }

    public void setXorRangeAndMask(Pointer p, int len, long mask) {
        int outOff = this.cp;
        int inOff = p.cp;
        for (int i = 0; i < len; ++i) {
            int n = outOff++;
            this.array[n] = this.array[n] ^ p.array[inOff++] & mask;
        }
    }

    public void setXorRangeAndMaskMove(Pointer p, int len, long mask) {
        int outOff = this.cp;
        for (int i = 0; i < len; ++i) {
            int n = outOff++;
            this.array[n] = this.array[n] ^ p.array[p.cp++] & mask;
        }
    }

    public void setRangeRotate(int outOff, Pointer p, int inOff, int len, int right) {
        int left = 64 - right;
        outOff += this.cp;
        inOff += p.cp;
        for (int i = 0; i < len; ++i) {
            this.array[outOff++] = p.array[inOff] >>> left ^ p.array[++inOff] << right;
        }
    }

    public void move(int p) {
        this.cp += p;
    }

    public void moveIncremental() {
        ++this.cp;
    }

    public long[] getArray() {
        return this.array;
    }

    public int getIndex() {
        return this.cp;
    }

    public void setAnd(int p, long v) {
        int n = this.cp + p;
        this.array[n] = this.array[n] & v;
    }

    public void setAnd(long v) {
        int n = this.cp;
        this.array[n] = this.array[n] & v;
    }

    public void setClear(int p) {
        this.array[this.cp + p] = 0L;
    }

    public void changeIndex(Pointer p) {
        this.array = p.array;
        this.cp = p.cp;
    }

    public void changeIndex(int p) {
        this.cp = p;
    }

    public void changeIndex(Pointer p, int idx) {
        this.array = p.array;
        this.cp = p.cp + idx;
    }

    public void setRangeClear(int pos, int size) {
        Arrays.fill(this.array, pos += this.cp, pos + size, 0L);
    }

    public int getLength() {
        return this.array.length - this.cp;
    }

    public void copyFrom(Pointer src, int len) {
        System.arraycopy(src.array, src.cp, this.array, this.cp, len);
    }

    public void copyFrom(int shift, Pointer src, int inOff, int len) {
        System.arraycopy(src.array, src.cp + inOff, this.array, this.cp + shift, len);
    }

    public void set1_gf2n(int startPos, int size) {
        int pos = this.cp + startPos;
        this.array[pos++] = 1L;
        for (int i = 1; i < size; ++i) {
            this.array[pos++] = 0L;
        }
    }

    public byte[] toBytes(int length) {
        byte[] res = new byte[length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(this.array[this.cp + (i >>> 3)] >>> ((i & 7) << 3));
        }
        return res;
    }

    public void indexReset() {
        this.cp = 0;
    }

    public void fillRandom(int shift, SecureRandom random, int length) {
        byte[] rv = new byte[length];
        random.nextBytes(rv);
        this.fill(shift, rv, 0, rv.length);
    }

    public void fill(int shift, byte[] arr, int input_cp, int len) {
        int q;
        int i = 0;
        for (q = this.cp + shift; q < this.array.length && i + 8 <= len; ++q) {
            this.array[q] = Pack.littleEndianToLong(arr, input_cp);
            input_cp += 8;
            i += 8;
        }
        if (i < len && q < this.array.length) {
            int r = 0;
            this.array[q] = 0L;
            while (r < 8 && i < len) {
                int n = q;
                this.array[n] = this.array[n] | ((long)arr[input_cp] & 0xFFL) << (r << 3);
                ++r;
                ++input_cp;
                ++i;
            }
        }
    }

    public void setRangeFromXor(int outOff, Pointer a, int aOff, Pointer b, int bOff, int len) {
        outOff += this.cp;
        aOff += a.cp;
        bOff += b.cp;
        for (int i = 0; i < len; ++i) {
            this.array[outOff++] = a.array[aOff++] ^ b.array[bOff++];
        }
    }

    public void setRangeFromXor(Pointer a, Pointer b, int len) {
        int outOff = this.cp;
        int aOff = a.cp;
        int bOff = b.cp;
        for (int i = 0; i < len; ++i) {
            this.array[outOff++] = a.array[aOff++] ^ b.array[bOff++];
        }
    }

    public void setRangeFromXorAndMask_xor(Pointer a, Pointer b, long mask, int len) {
        int outOff = this.cp;
        int a_cp = a.cp;
        int b_cp = b.cp;
        for (int i = 0; i < len; ++i) {
            this.array[outOff] = (a.array[a_cp] ^ b.array[b_cp]) & mask;
            int n = a_cp++;
            a.array[n] = a.array[n] ^ this.array[outOff];
            int n2 = b_cp++;
            b.array[n2] = b.array[n2] ^ this.array[outOff++];
        }
    }

    public int is0_gf2n(int p, int size) {
        long r = this.get(p);
        for (int i = 1; i < size; ++i) {
            r |= this.get(p + i);
        }
        return (int)GeMSSUtils.NORBITS_UINT(r);
    }

    public long getDotProduct(int off, Pointer b, int bOff, int len) {
        off += this.cp;
        bOff += b.cp;
        long res = this.array[off++] & b.array[bOff++];
        for (int i = 1; i < len; ++i) {
            res ^= this.array[off++] & b.array[bOff++];
        }
        return res;
    }

    public int getD_for_not0_or_plus(int NB_WORD_GFqn, int start) {
        int d = 0;
        long mask = 0L;
        int pos = this.cp;
        for (int i = start; i > 0; --i) {
            long b = this.array[pos++];
            for (int j = 1; j < NB_WORD_GFqn; ++j) {
                b |= this.array[pos++];
            }
            d = (int)((long)d + (mask |= GeMSSUtils.ORBITS_UINT(b)));
        }
        return d;
    }

    public int setRange_xi(long xi, int k, int len) {
        int j = 0;
        while (j < len) {
            this.array[this.cp + k] = -(xi >>> j & 1L);
            ++j;
            ++k;
        }
        return k;
    }

    public int searchDegree(int da, int db, int NB_WORD_GFqn) {
        while (this.is0_gf2n(da * NB_WORD_GFqn, NB_WORD_GFqn) != 0 && da >= db) {
            --da;
        }
        return da;
    }

    public void setRangePointerUnion(PointerUnion p, int len) {
        if (p.remainder == 0) {
            System.arraycopy(p.array, p.cp, this.array, this.cp, len);
        } else {
            int left = 8 - p.remainder << 3;
            int right = p.remainder << 3;
            int outOff = this.cp;
            int inOff = p.cp;
            for (int i = 0; i < len; ++i) {
                this.array[outOff++] = p.array[inOff] >>> right ^ p.array[++inOff] << left;
            }
        }
    }

    public void setRangePointerUnion(PointerUnion p, int len, int shift) {
        int right2 = shift & 0x3F;
        int left2 = 64 - right2;
        int outOff = this.cp;
        int inOff = p.cp;
        if (p.remainder == 0) {
            for (int i = 0; i < len; ++i) {
                this.array[outOff++] = p.array[inOff] >>> right2 ^ p.array[++inOff] << left2;
            }
        } else {
            int right1 = p.remainder << 3;
            int left1 = 8 - p.remainder << 3;
            for (int i = 0; i < len; ++i) {
                this.array[outOff++] = (p.array[inOff] >>> right1 | p.array[++inOff] << left1) >>> right2 ^ (p.array[inOff] >>> right1 | p.array[inOff + 1] << left1) << left2;
            }
        }
    }

    public void setRangePointerUnion_Check(PointerUnion p, int len, int shift) {
        int right2 = shift & 0x3F;
        int left2 = 64 - right2;
        int outOff = this.cp;
        int inOff = p.cp;
        if (p.remainder == 0) {
            int i;
            for (i = 0; i < len && inOff < p.array.length - 1; ++i) {
                this.array[outOff++] = p.array[inOff] >>> right2 ^ p.array[++inOff] << left2;
            }
            if (i < len) {
                this.array[outOff] = p.array[inOff] >>> right2;
            }
        } else {
            int i;
            int right1 = p.remainder << 3;
            int left1 = 8 - p.remainder << 3;
            for (i = 0; i < len && inOff < p.array.length - 2; ++i) {
                this.array[outOff++] = (p.array[inOff] >>> right1 | p.array[++inOff] << left1) >>> right2 ^ (p.array[inOff] >>> right1 | p.array[inOff + 1] << left1) << left2;
            }
            if (i < len) {
                this.array[outOff] = (p.array[inOff] >>> right1 | p.array[++inOff] << left1) >>> right2 ^ p.array[inOff] >>> right1 << left2;
            }
        }
    }

    public int isEqual_nocst_gf2(Pointer b, int len) {
        int inOff = b.cp;
        int outOff = this.cp;
        for (int i = 0; i < len; ++i) {
            if (this.array[outOff++] == b.array[inOff++]) continue;
            return 0;
        }
        return 1;
    }

    public void swap(Pointer b) {
        long[] tmp_array = b.array;
        int tmp_cp = b.cp;
        b.array = this.array;
        b.cp = this.cp;
        this.array = tmp_array;
        this.cp = tmp_cp;
    }
}

