/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.Utils;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class SNTRUPrimeKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom random;

    public SNTRUPrimeKEMGenerator(SecureRandom random) {
        this.random = random;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        SNTRUPrimePublicKeyParameters publicKey = (SNTRUPrimePublicKeyParameters)recipientKey;
        SNTRUPrimeParameters params = publicKey.getParameters();
        int p = params.getP();
        int q = params.getQ();
        int w = params.getW();
        int roundedPolynomialBytes = params.getRoundedPolynomialBytes();
        byte[] cachePrefix = new byte[]{4};
        byte[] cache = Utils.getHashWithPrefix(cachePrefix, publicKey.getEncoded());
        byte[] r = new byte[p];
        Utils.getRandomShortPolynomial(this.random, r, p, w);
        byte[] encR = new byte[(p + 3) / 4];
        Utils.getEncodedSmallPolynomial(encR, r, p);
        short[] h = new short[p];
        Utils.getDecodedPolynomial(h, publicKey.getEncH(), p, q);
        short[] hr = new short[p];
        Utils.multiplicationInRQ(hr, h, r, p, q);
        short[] c = new short[p];
        Utils.roundPolynomial(c, hr);
        byte[] C = new byte[roundedPolynomialBytes];
        Utils.getRoundedEncodedPolynomial(C, c, p, q);
        byte[] innerHCPrefix = new byte[]{3};
        byte[] innerHCHash = Utils.getHashWithPrefix(innerHCPrefix, encR);
        byte[] hcInput = new byte[innerHCHash.length / 2 + cache.length / 2];
        System.arraycopy(innerHCHash, 0, hcInput, 0, innerHCHash.length / 2);
        System.arraycopy(cache, 0, hcInput, innerHCHash.length / 2, cache.length / 2);
        byte[] hcPrefix = new byte[]{2};
        byte[] hc = Utils.getHashWithPrefix(hcPrefix, hcInput);
        byte[] ct = new byte[C.length + hc.length / 2];
        System.arraycopy(C, 0, ct, 0, C.length);
        System.arraycopy(hc, 0, ct, C.length, hc.length / 2);
        byte[] innerSSPrefix = new byte[]{3};
        byte[] innerSSHash = Utils.getHashWithPrefix(innerSSPrefix, encR);
        byte[] ssInput = new byte[innerSSHash.length / 2 + ct.length];
        System.arraycopy(innerSSHash, 0, ssInput, 0, innerSSHash.length / 2);
        System.arraycopy(ct, 0, ssInput, innerSSHash.length / 2, ct.length);
        byte[] ssPrefix = new byte[]{1};
        byte[] ssHash = Utils.getHashWithPrefix(ssPrefix, ssInput);
        byte[] ss = Arrays.copyOfRange(ssHash, 0, params.getSessionKeySize() / 8);
        return new SecretWithEncapsulationImpl(ss, ct);
    }
}

