/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus;

import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.ADRS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

class WotsPlus {
    private final SPHINCSPlusEngine engine;
    private final int w;

    WotsPlus(SPHINCSPlusEngine engine) {
        this.engine = engine;
        this.w = this.engine.WOTS_W;
    }

    byte[] pkGen(byte[] skSeed, byte[] pkSeed, ADRS paramAdrs) {
        ADRS wotspkADRS = new ADRS(paramAdrs);
        byte[][] tmp = new byte[this.engine.WOTS_LEN][];
        for (int i = 0; i < this.engine.WOTS_LEN; ++i) {
            ADRS adrs = new ADRS(paramAdrs);
            adrs.setType(5);
            adrs.setKeyPairAddress(paramAdrs.getKeyPairAddress());
            adrs.setChainAddress(i);
            adrs.setHashAddress(0);
            byte[] sk = this.engine.PRF(pkSeed, skSeed, adrs);
            adrs.setType(0);
            adrs.setKeyPairAddress(paramAdrs.getKeyPairAddress());
            adrs.setChainAddress(i);
            adrs.setHashAddress(0);
            tmp[i] = this.chain(sk, 0, this.w - 1, pkSeed, adrs);
        }
        wotspkADRS.setType(1);
        wotspkADRS.setKeyPairAddress(paramAdrs.getKeyPairAddress());
        return this.engine.T_l(pkSeed, wotspkADRS, Arrays.concatenate(tmp));
    }

    byte[] chain(byte[] X, int i, int s, byte[] pkSeed, ADRS adrs) {
        if (s == 0) {
            return Arrays.clone(X);
        }
        if (i + s > this.w - 1) {
            return null;
        }
        byte[] result = X;
        for (int j = 0; j < s; ++j) {
            adrs.setHashAddress(i + j);
            result = this.engine.F(pkSeed, adrs, result);
        }
        return result;
    }

    public byte[] sign(byte[] M, byte[] skSeed, byte[] pkSeed, ADRS paramAdrs) {
        ADRS adrs = new ADRS(paramAdrs);
        int[] msg = new int[this.engine.WOTS_LEN];
        this.base_w(M, 0, this.w, msg, 0, this.engine.WOTS_LEN1);
        int csum = 0;
        for (int i = 0; i < this.engine.WOTS_LEN1; ++i) {
            csum += this.w - 1 - msg[i];
        }
        if (this.engine.WOTS_LOGW % 8 != 0) {
            csum <<= 8 - this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW % 8;
        }
        int len_2_bytes = (this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW + 7) / 8;
        byte[] csum_bytes = Pack.intToBigEndian(csum);
        this.base_w(csum_bytes, 4 - len_2_bytes, this.w, msg, this.engine.WOTS_LEN1, this.engine.WOTS_LEN2);
        byte[][] sig = new byte[this.engine.WOTS_LEN][];
        for (int i = 0; i < this.engine.WOTS_LEN; ++i) {
            adrs.setType(5);
            adrs.setKeyPairAddress(paramAdrs.getKeyPairAddress());
            adrs.setChainAddress(i);
            adrs.setHashAddress(0);
            byte[] sk = this.engine.PRF(pkSeed, skSeed, adrs);
            adrs.setType(0);
            adrs.setKeyPairAddress(paramAdrs.getKeyPairAddress());
            adrs.setChainAddress(i);
            adrs.setHashAddress(0);
            sig[i] = this.chain(sk, 0, msg[i], pkSeed, adrs);
        }
        return Arrays.concatenate(sig);
    }

    void base_w(byte[] X, int XOff, int w, int[] output, int outOff, int outLen) {
        byte total = 0;
        int bits = 0;
        for (int consumed = 0; consumed < outLen; ++consumed) {
            if (bits == 0) {
                total = X[XOff++];
                bits += 8;
            }
            output[outOff++] = total >>> (bits -= this.engine.WOTS_LOGW) & w - 1;
        }
    }

    public byte[] pkFromSig(byte[] sig, byte[] M, byte[] pkSeed, ADRS adrs) {
        ADRS wotspkADRS = new ADRS(adrs);
        int[] msg = new int[this.engine.WOTS_LEN];
        this.base_w(M, 0, this.w, msg, 0, this.engine.WOTS_LEN1);
        int csum = 0;
        for (int i = 0; i < this.engine.WOTS_LEN1; ++i) {
            csum += this.w - 1 - msg[i];
        }
        int len_2_bytes = (this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW + 7) / 8;
        byte[] csum_bytes = Pack.intToBigEndian(csum <<= 8 - this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW % 8);
        this.base_w(csum_bytes, 4 - len_2_bytes, this.w, msg, this.engine.WOTS_LEN1, this.engine.WOTS_LEN2);
        byte[] sigI = new byte[this.engine.N];
        byte[][] tmp = new byte[this.engine.WOTS_LEN][];
        for (int i = 0; i < this.engine.WOTS_LEN; ++i) {
            adrs.setChainAddress(i);
            System.arraycopy(sig, i * this.engine.N, sigI, 0, this.engine.N);
            tmp[i] = this.chain(sigI, msg[i], this.w - 1 - msg[i], pkSeed, adrs);
        }
        wotspkADRS.setType(1);
        wotspkADRS.setKeyPairAddress(adrs.getKeyPairAddress());
        return this.engine.T_l(pkSeed, wotspkADRS, Arrays.concatenate(tmp));
    }
}

