/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.PrivateKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.McEliecePrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.mceliece.McEliecePrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Matrix;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;

public class BCMcEliecePrivateKey
implements CipherParameters,
PrivateKey {
    private static final long serialVersionUID = 1L;
    private McEliecePrivateKeyParameters params;

    public BCMcEliecePrivateKey(McEliecePrivateKeyParameters params) {
        this.params = params;
    }

    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public GF2mField getField() {
        return this.params.getField();
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.params.getGoppaPoly();
    }

    public GF2Matrix getSInv() {
        return this.params.getSInv();
    }

    public Permutation getP1() {
        return this.params.getP1();
    }

    public Permutation getP2() {
        return this.params.getP2();
    }

    public GF2Matrix getH() {
        return this.params.getH();
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.params.getQInv();
    }

    public boolean equals(Object other) {
        if (!(other instanceof BCMcEliecePrivateKey)) {
            return false;
        }
        BCMcEliecePrivateKey otherKey = (BCMcEliecePrivateKey)other;
        return this.getN() == otherKey.getN() && this.getK() == otherKey.getK() && this.getField().equals(otherKey.getField()) && this.getGoppaPoly().equals(otherKey.getGoppaPoly()) && this.getSInv().equals(otherKey.getSInv()) && this.getP1().equals(otherKey.getP1()) && this.getP2().equals(otherKey.getP2());
    }

    public int hashCode() {
        int code = this.params.getK();
        code = code * 37 + this.params.getN();
        code = code * 37 + this.params.getField().hashCode();
        code = code * 37 + this.params.getGoppaPoly().hashCode();
        code = code * 37 + this.params.getP1().hashCode();
        code = code * 37 + this.params.getP2().hashCode();
        return code * 37 + this.params.getSInv().hashCode();
    }

    public byte[] getEncoded() {
        PrivateKeyInfo pki;
        McEliecePrivateKey privateKey = new McEliecePrivateKey(this.params.getN(), this.params.getK(), this.params.getField(), this.params.getGoppaPoly(), this.params.getP1(), this.params.getP2(), this.params.getSInv());
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcEliece);
            pki = new PrivateKeyInfo(algorithmIdentifier, privateKey);
        }
        catch (IOException e) {
            return null;
        }
        try {
            byte[] encoded = pki.getEncoded();
            return encoded;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

