/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntru;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.NTRUKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.NTRUParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BCNTRUPublicKey
implements PublicKey,
NTRUKey {
    private static final long serialVersionUID = 1L;
    private transient NTRUPublicKeyParameters params;

    public BCNTRUPublicKey(NTRUPublicKeyParameters params) {
        this.params = params;
    }

    public BCNTRUPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.params = (NTRUPublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCNTRUPublicKey) {
            BCNTRUPublicKey otherKey = (BCNTRUPublicKey)o;
            return Arrays.areEqual(this.params.getEncoded(), otherKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return "NTRU";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public NTRUParameterSpec getParameterSpec() {
        return NTRUParameterSpec.fromName(this.params.getParameters().getName());
    }

    NTRUPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

