/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntruprime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.NTRULPRimeKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.NTRULPRimeParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BCNTRULPRimePublicKey
implements PublicKey,
NTRULPRimeKey {
    private static final long serialVersionUID = 1L;
    private transient NTRULPRimePublicKeyParameters params;

    public BCNTRULPRimePublicKey(NTRULPRimePublicKeyParameters params) {
        this.params = params;
    }

    public BCNTRULPRimePublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.params = (NTRULPRimePublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCNTRULPRimePublicKey) {
            BCNTRULPRimePublicKey otherKey = (BCNTRULPRimePublicKey)o;
            return Arrays.areEqual(this.params.getEncoded(), otherKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return "NTRULPRime";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public NTRULPRimeParameterSpec getParameterSpec() {
        return NTRULPRimeParameterSpec.fromName(this.params.getParameters().getName());
    }

    NTRULPRimePublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

