/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.mceliece;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.mceliece.McEliecePrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.mceliece.McEliecePublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Matrix;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.GoppaCode;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialRingGF2m;

public class McElieceKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";
    private McElieceKeyGenerationParameters mcElieceParams;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceKeyGenerationParameters mcParams = new McElieceKeyGenerationParameters(null, new McElieceParameters());
        this.initialize(mcParams);
    }

    private void initialize(KeyGenerationParameters param) {
        this.mcElieceParams = (McElieceKeyGenerationParameters)param;
        this.random = param.getRandom();
        this.m = this.mcElieceParams.getParameters().getM();
        this.n = this.mcElieceParams.getParameters().getN();
        this.t = this.mcElieceParams.getParameters().getT();
        this.fieldPoly = this.mcElieceParams.getParameters().getFieldPoly();
        this.initialized = true;
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField field = new GF2mField(this.m, this.fieldPoly);
        PolynomialGF2mSmallM gp = new PolynomialGF2mSmallM(field, this.t, 'I', this.random);
        PolynomialRingGF2m ring = new PolynomialRingGF2m(field, gp);
        PolynomialGF2mSmallM[] sqRootMatrix = ring.getSquareRootMatrix();
        GF2Matrix h = GoppaCode.createCanonicalCheckMatrix(field, gp);
        GoppaCode.MaMaPe mmp = GoppaCode.computeSystematicForm(h, this.random);
        GF2Matrix shortH = mmp.getSecondMatrix();
        Permutation p1 = mmp.getPermutation();
        GF2Matrix shortG = (GF2Matrix)shortH.computeTranspose();
        GF2Matrix gPrime = shortG.extendLeftCompactForm();
        int k = shortG.getNumRows();
        GF2Matrix[] matrixSandInverse = GF2Matrix.createRandomRegularMatrixAndItsInverse(k, this.random);
        Permutation p2 = new Permutation(this.n, this.random);
        GF2Matrix g = (GF2Matrix)matrixSandInverse[0].rightMultiply(gPrime);
        g = (GF2Matrix)g.rightMultiply(p2);
        McEliecePublicKeyParameters pubKey = new McEliecePublicKeyParameters(this.n, this.t, g);
        McEliecePrivateKeyParameters privKey = new McEliecePrivateKeyParameters(this.n, k, field, gp, p1, p2, matrixSandInverse[1]);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

