/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.smime.SmimePublicKey;
import net.savignano.cryptography.util.KeyStoreContentFetcher;
import net.savignano.cryptography.util.SmimeUtil;
import org.slf4j.Logger;

public class SmimeCertificateKeyStoreLoader
extends AKeyLoader<SmimePublicKey, String> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final KeyStore keyStore;

    public SmimeCertificateKeyStoreLoader(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    protected SmimePublicKey loadInternalKey(String email) throws Exception {
        SmimePublicKey key;
        if (this.keyStore == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        Logger log = this.getLog();
        log.info("Looking up S/MIME certificate for email <{}> in public key store.", (Object)email);
        X509Certificate certificate = SmimeUtil.getValidCertForEmail(this.getKeyStore(), email, EKeyPurpose.ENCRYPTION);
        if (certificate != null) {
            log.info("Found valid S/MIME certificate for email <{}> in public key store.", (Object)email);
            log.trace("Found certificate: {}", (Object)certificate);
            this.getInfoDataManager().send(new InfoData(202, email));
            SmimePublicKey key2 = new SmimePublicKey(certificate, email);
            key2.setKeySource(this.getKeySource());
            return key2;
        }
        try {
            KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(this.getKeyStore());
            certificate = fetcher.getCertFor(SmimeUtil.createPredicateForEmail(email)).orElseGet(() -> null);
        }
        catch (KeyStoreException e) {
            log.warn("Could not load certificate from public key store for email <" + email + ">.", (Throwable)e);
            this.getInfoDataManager().send(new InfoData(102, e));
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Found no valid S/MIME certificate for email <{}> in public key store.", (Object)email);
        log.trace("Found certificate: {}", (Object)certificate);
        if (certificate != null) {
            this.getInfoDataManager().send(new InfoData(202, email));
            key = new SmimePublicKey(certificate);
            key.setKeySource(this.getKeySource());
            return key;
        }
        this.getInfoDataManager().send(new InfoData(203, email));
        key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        return key;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SmimePublicKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        return "SmimeCertificateKeyStoreLoader [keyStore=" + this.keyStore + "]";
    }
}

