/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.validate;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.Set;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.validate.IMailValidator;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailValidator<T extends IPublicCryptographyKey<?>>
extends BaseMailCryptography<T>
implements IMailValidator<T> {
    protected AMailValidator(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    protected abstract T getValidityKey(EKeyValidity var1);

    @Override
    public boolean validateMessage(MimeMessage msg, Set<EValidationType> validations) {
        boolean valid;
        if (msg == null) {
            return false;
        }
        if (validations == null || validations.isEmpty()) {
            return true;
        }
        Optional<String> email = MessageUtil.getFromEmail(msg);
        if (!email.isPresent()) {
            return false;
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId(msg);
        try {
            if (!this.isSigned(msg)) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("Could not check if message with msg ID " + msgId + " is signed. Error message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        log.info("Validating message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        try {
            this.traceMessage(msg, "Email:\n{}\n");
        }
        catch (Exception e) {
            log.error("Could not log message. Error message: " + e.getMessage(), (Throwable)e);
        }
        try {
            valid = this.validate(msg, validations, email.get());
        }
        catch (Exception e) {
            log.error("Could not validate message with msg ID " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            valid = false;
        }
        log.info("Finished validating message for {} with msg ID {}. Result: {}", new Object[]{this.getCryptography(), msgId, valid ? EKeyValidity.VALID : EKeyValidity.INVALID});
        return valid;
    }

    protected abstract boolean isSigned(MimeMessage var1) throws Exception;

    protected abstract boolean validate(MimeMessage var1, Set<EValidationType> var2, String var3) throws Exception;

    @Override
    public T extractPublicKey(MimeMessage msg) {
        T key;
        if (msg == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        Optional<String> email = MessageUtil.getFromEmail(msg);
        if (!email.isPresent()) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId(msg);
        log.info("Extracing public key from message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            try {
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Email:\n{}\n", (Object)debugBaos.toString());
            }
            catch (Exception e) {
                log.error("Could not log message. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            key = this.extract(msg, email.get());
        }
        catch (Exception e) {
            log.error("Could not extract public key from message with msg ID " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            key = this.getValidityKey(EKeyValidity.ERROR);
        }
        if (key == null) {
            key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("Finished extracing public key from message for {} with msg ID {}. Extracted key: {}", new Object[]{this.getCryptography(), msgId, key});
        return key;
    }

    protected abstract T extract(MimeMessage var1, String var2) throws Exception;
}

