/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import net.savignano.cryptography.enums.EKeySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeySourceComperator
implements Comparator<EKeySource> {
    private static final Logger log = LoggerFactory.getLogger(KeySourceComperator.class);
    private static final Map<EKeySource, Integer> keySourcePriority = new EnumMap<EKeySource, Integer>(EKeySource.class);

    @Override
    public int compare(EKeySource o1, EKeySource o2) {
        Integer priority1 = keySourcePriority.getOrDefault((Object)o1, Integer.MAX_VALUE);
        Integer priority2 = keySourcePriority.getOrDefault((Object)o2, Integer.MAX_VALUE);
        return priority1.compareTo(priority2);
    }

    static {
        keySourcePriority.put(EKeySource.USER, 0);
        keySourcePriority.put(EKeySource.EMAIL, 1);
        keySourcePriority.put(EKeySource.KEYSTORE, 2);
        keySourcePriority.put(EKeySource.LDAP, 3);
        keySourcePriority.put(EKeySource.ATLASSIAN_DIRECTORY, 3);
        keySourcePriority.put(EKeySource.EXTERNAL_LDAP, 4);
        keySourcePriority.put(EKeySource.STANDARD_LDAP, 4);
        keySourcePriority.put(EKeySource.KEYSERVER, 5);
        keySourcePriority.put(EKeySource.UNKNOWN, 6);
        if (keySourcePriority.size() != EKeySource.values().length) {
            log.error("KeySource Priority Map has only {} entries, expecting {}.", (Object)keySourcePriority.size(), (Object)EKeySource.values().length);
        }
    }
}

