/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.connector;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import java.net.URI;
import java.net.URISyntaxException;
import javax.naming.ConfigurationException;
import net.savignano.cryptography.connector.LdapConnector;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianLdapConnector
extends LdapConnector {
    private static final String DEFAULT_USERNAME_KEY = "uid";
    private static final String LDAP_URL_PROP = "ldap.url";
    private static final String LDAP_BASEDN_PROP = "ldap.basedn";
    private static final String LDAP_USERDN_PROP = "ldap.user.dn";
    private static final String LDAP_USERNAME_PROP = "ldap.user.username";
    private static final String LDAP_USERFILTER_PROP = "ldap.user.filter";
    private static final String LDAP_LOGIN_USER_PROP = "ldap.userdn";
    private static final String LDAP_LOGIN_PASSWORD_PROP = "ldap.password";
    private static final String LDAP_REFERRAL_PROP = "ldap.referral";
    private static final String LDAP_SECURE_PROP = "ldap.secure";
    private static final Logger log = LoggerFactory.getLogger(AtlassianLdapConnector.class);
    private String userNameKey = "uid";

    public static boolean isConnector(Directory directory) {
        if (directory == null || !directory.isActive() || directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
            if (log.isDebugEnabled()) {
                if (directory == null) {
                    log.debug("Null directory given.");
                } else if (!directory.isActive()) {
                    log.debug("Directory {} is not active.", (Object)directory.getName());
                } else if (directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
                    log.debug("Directory {} is not of type 'CONNECTOR' nor 'DELEGATING'. Type found: {}", (Object)directory.getName(), (Object)directory.getType());
                } else {
                    log.debug("Unknown reason why directory is considered unsuitable to create a connector. Probably implementation problem. Given directory: {}", (Object)directory);
                }
            }
            return false;
        }
        String ldapUrl = directory.getValue(LDAP_URL_PROP);
        String ldapBaseDn = directory.getValue(LDAP_BASEDN_PROP);
        boolean isLdap = !StringUtils.isBlank((String)ldapUrl) && !StringUtils.isBlank((String)ldapBaseDn);
        log.debug("Directory {} is considered to be an LDAP: {}", (Object)directory.getName(), (Object)isLdap);
        return isLdap;
    }

    public static AtlassianLdapConnector createConnector(Directory directory) throws ConfigurationException {
        URI ldapUri;
        if (directory == null || !directory.isActive() || directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
            String reason = directory == null ? "Null directory given." : (!directory.isActive() ? "Directory " + directory.getName() + " is not active." : (directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING ? "Directory " + directory.getName() + " is not of type 'CONNECTOR' nor 'DELEGATING'. Type found: " + directory.getType() : "Unknown reason why data extraction is skipped. Probably implementation problem. Given directory: " + directory));
            throw new ConfigurationException(reason);
        }
        String ldapUrl = directory.getValue(LDAP_URL_PROP);
        log.trace("LDAP URL: {}", (Object)ldapUrl);
        String ldapBaseDn = directory.getValue(LDAP_BASEDN_PROP);
        log.trace("LDAP Base DN: {}", (Object)ldapBaseDn);
        String ldapUserDn = directory.getValue(LDAP_USERDN_PROP);
        log.trace("LDAP User DN: {}", (Object)ldapUserDn);
        String ldapLoginUser = directory.getValue(LDAP_LOGIN_USER_PROP);
        log.trace("LDAP Login User: {}", (Object)ldapLoginUser);
        String ldapLoginPassword = directory.getValue(LDAP_LOGIN_PASSWORD_PROP);
        log.trace("LDAP Login Password: {}", (Object)(ldapLoginPassword == null ? null : "*****"));
        String ldapUserNameKey = directory.getValue(LDAP_USERNAME_PROP);
        log.trace("LDAP User Name Key: {}", (Object)ldapUserNameKey);
        String ldapFilter = directory.getValue(LDAP_USERFILTER_PROP);
        log.trace("LDAP Filter: {}", (Object)ldapFilter);
        String ldapReferral = directory.getValue(LDAP_REFERRAL_PROP);
        log.trace("LDAP Referral: {}", (Object)ldapReferral);
        String ldapSecure = directory.getValue(LDAP_SECURE_PROP);
        log.trace("LDAP Secure: {}", (Object)ldapSecure);
        if (StringUtils.isBlank((String)ldapUrl) || StringUtils.isBlank((String)ldapBaseDn)) {
            throw new ConfigurationException("Could not extract needed keys from this directory. Is probably not connecting to an LDAP.");
        }
        String userBase = ldapBaseDn;
        if (StringUtils.isNotBlank((String)ldapUserDn)) {
            userBase = ldapUserDn + "," + userBase;
        }
        try {
            ldapUri = new URI(ldapUrl);
        }
        catch (URISyntaxException e) {
            ConfigurationException configException = new ConfigurationException("The given URL could not be parsed: " + ldapUrl);
            configException.initCause(e);
            throw configException;
        }
        AtlassianLdapConnector connector = new AtlassianLdapConnector();
        connector.setHost(ldapUri.getHost());
        connector.setPort(ldapUri.getPort());
        connector.setSsl("ldaps".equals(ldapUri.getScheme()));
        connector.setDn(userBase);
        connector.setLoginUser(ldapLoginUser);
        connector.setDisableTrustCheck(!Boolean.parseBoolean(ldapSecure));
        if (ldapLoginPassword != null && StringUtils.isNotBlank((String)ldapLoginPassword)) {
            connector.setLoginPassword(ldapLoginPassword.toCharArray());
        }
        if (StringUtils.isNotBlank((String)ldapUserNameKey)) {
            connector.setUserNameKey(ldapUserNameKey);
        }
        if (StringUtils.isNotBlank((String)ldapFilter)) {
            connector.setFilter(ldapFilter);
        }
        if (StringUtils.isNotBlank((String)ldapReferral)) {
            connector.setReferral(Boolean.parseBoolean(ldapReferral) ? "follow" : "ignore");
        }
        return connector;
    }

    public String getUserNameKey() {
        return this.userNameKey;
    }

    public void setUserNameKey(String userNameKey) {
        this.userNameKey = userNameKey == null ? DEFAULT_USERNAME_KEY : userNameKey;
    }

    @Override
    public String toString() {
        return "AtlassianLdapConnector [userNameKey=" + this.getUserNameKey() + ", connector=" + super.toString() + "]";
    }
}

