/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.properties;

import java.security.GeneralSecurityException;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyAppProperties
implements ISnotifyAppProperties {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyAppProperties.class);
    private static final String SETTINGS_STRING_EXISTS = ".exists";
    private static final String SETTINGS_STRING_PAGES = ".pages";
    private static final String SETTINGS_STRING_PAGE = ".page.";

    @Override
    public boolean hasKey(EProperty prop) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (prop.getPropType() != EProperty.EPropertyType.GLOBAL) {
            log.warn("Given property {} is of type {}, but {} is expected. Probably wrong property given.", new Object[]{prop.name(), prop.getPropType(), EProperty.EPropertyType.GLOBAL});
        }
        return this.hasKey(prop.getKey());
    }

    protected boolean hasKey(String key) {
        if (this.getString(key) != null) {
            return true;
        }
        Boolean exists = this.getBoolean(key + SETTINGS_STRING_EXISTS);
        return exists != null && exists != false;
    }

    @Override
    public final String getString(EProperty prop) {
        if (this.checkType(String.class, prop)) {
            String value = this.getString(prop.getKey());
            return value != null ? value : (String)prop.getDefaultValue();
        }
        return null;
    }

    public final String getAsString(EProperty prop) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return null;
        }
        return this.getString(prop.getKey());
    }

    protected abstract String getString(String var1);

    @Override
    public final String getUnlimitedString(EProperty prop) {
        if (this.checkType(String.class, prop)) {
            String value = this.getUnlimitedString(prop.getKey());
            return value != null ? value : (String)prop.getDefaultValue();
        }
        return null;
    }

    protected String getUnlimitedString(String key) {
        Boolean exists = this.getBoolean(key + SETTINGS_STRING_EXISTS);
        if (exists == null || !exists.booleanValue()) {
            return null;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES);
        if (pagesValue == null) {
            return null;
        }
        int pages = pagesValue.intValue();
        StringBuilder builder = new StringBuilder(255 * pages);
        for (int i = 0; i < pages; ++i) {
            String page = this.getString(key + SETTINGS_STRING_PAGE + i);
            builder.append(page);
        }
        String value = builder.toString();
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public final char[] getPassword(EProperty prop) {
        if (this.checkType(char[].class, prop)) {
            char[] value = this.getPassword(prop.getKey());
            return value != null ? value : (char[])prop.getDefaultValue();
        }
        return null;
    }

    protected char[] getPassword(String key) {
        String value = this.getString(key);
        try {
            return SecurityUtil.decodeCharsBase64Aes(value);
        }
        catch (GeneralSecurityException e) {
            log.error("Value " + value + " stored in application property " + key + " is not a password.", (Throwable)e);
            return null;
        }
    }

    @Override
    public final boolean getBoolean(EProperty prop) {
        if (this.checkType(Boolean.class, prop)) {
            Boolean value = this.getBoolean(prop.getKey());
            return value != null ? value : (Boolean)prop.getDefaultValue();
        }
        return false;
    }

    @Override
    public final boolean getBoolean(EProperty prop, boolean defaultValue) {
        if (this.checkType(Boolean.class, prop)) {
            Boolean value = this.getBoolean(prop.getKey());
            return value != null ? value : defaultValue;
        }
        return false;
    }

    protected Boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public final Long getLong(EProperty prop) {
        if (this.checkType(Long.class, prop)) {
            Long value = this.getLong(prop.getKey());
            return value != null ? value : (Long)prop.getDefaultValue();
        }
        return null;
    }

    protected Long getLong(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.error("Value " + value + " stored in application property " + key + " is not a Long.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public final <T extends Enum<T>> T getEnum(EProperty prop, Class<T> clazz) {
        if (this.checkType(clazz, prop)) {
            T value = this.getEnum(prop.getKey(), clazz);
            return (T)(value != null ? value : (Enum)prop.getDefaultValue());
        }
        return null;
    }

    protected <T extends Enum<T>> T getEnum(String key, Class<T> clazz) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                log.error("Value " + value + " stored in application property " + key + " is not a valid value for enum " + clazz.getSimpleName() + ".", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public final byte[] getBytes(EProperty prop) {
        if (this.checkType(byte[].class, prop)) {
            byte[] value = this.getBytes(prop.getKey());
            return value != null ? value : (byte[])prop.getDefaultValue();
        }
        return null;
    }

    protected byte[] getBytes(String key) {
        String base64Value = this.getUnlimitedString(key);
        if (base64Value != null) {
            return Base64.decodeBase64((byte[])base64Value.getBytes(Constants.UTF8_CHARSET));
        }
        return null;
    }

    @Override
    public final void setString(EProperty prop, String value) {
        if (this.checkType(String.class, prop)) {
            this.setString(prop.getKey(), value);
        }
    }

    public final void setAsString(EProperty prop, String value) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return;
        }
        this.setString(prop.getKey(), value);
    }

    protected abstract void setString(String var1, String var2);

    @Override
    public final void setUnlimitedString(EProperty prop, String value) {
        if (this.checkType(String.class, prop)) {
            this.setUnlimitedString(prop.getKey(), value);
        }
    }

    protected void setUnlimitedString(String key, String value) {
        this.removeUnlimitedString(key);
        if (value != null) {
            int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
            if (pages > 0) {
                for (int i = 0; i < pages - 1; ++i) {
                    this.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255));
                }
                this.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255));
            }
            this.setLong(key + SETTINGS_STRING_PAGES, Long.valueOf(pages));
            this.setBoolean(key + SETTINGS_STRING_EXISTS, true);
        }
    }

    private void removeUnlimitedString(String key) {
        Boolean exists = this.getBoolean(key + SETTINGS_STRING_EXISTS);
        if (exists == null || !exists.booleanValue()) {
            return;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES);
        if (pagesValue == null) {
            return;
        }
        this.setString(key + SETTINGS_STRING_EXISTS, null);
        this.setLong(key + SETTINGS_STRING_PAGES, null);
        int pages = pagesValue.intValue();
        for (int i = 0; i < pages; ++i) {
            this.setString(key + SETTINGS_STRING_PAGE + i, null);
        }
    }

    @Override
    public final void setPassword(EProperty prop, char[] value) {
        if (this.checkType(char[].class, prop)) {
            this.setPassword(prop.getKey(), value);
        }
    }

    protected void setPassword(String key, char[] value) {
        if (value == null || value.length == 0) {
            this.setString(key, null);
        } else {
            if (value.length > 255) {
                throw new IllegalArgumentException("Password cannot be longer than 255 characters.");
            }
            try {
                this.setString(key, SecurityUtil.encode(value));
            }
            catch (GeneralSecurityException e) {
                log.error("Could not store password for key " + key + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public final void setBoolean(EProperty prop, boolean value) {
        if (this.checkType(Boolean.class, prop)) {
            this.setBoolean(prop.getKey(), value);
        }
    }

    protected void setBoolean(String key, boolean value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public final void setLong(EProperty prop, Long value) {
        if (this.checkType(Long.class, prop)) {
            this.setLong(prop.getKey(), value);
        }
    }

    protected void setLong(String key, Long value) {
        this.setString(key, value == null ? null : value.toString());
    }

    @Override
    public final void setEnum(EProperty prop, Enum<?> value) {
        if (value == null) {
            if (prop == null) {
                log.error("Given property was null.", (Throwable)new NullPointerException());
            } else if (!prop.getType().isEnum()) {
                log.error("Property {} is not an enum.", (Object)prop.name());
            } else {
                this.setEnum(prop.getKey(), null);
            }
        } else if (this.checkType(value.getClass(), prop)) {
            this.setEnum(prop.getKey(), value);
        }
    }

    protected void setEnum(String key, Enum<?> value) {
        this.setString(key, value == null ? null : value.name());
    }

    @Override
    public final void setBytes(EProperty prop, byte[] value) {
        if (this.checkType(byte[].class, prop)) {
            this.setBytes(prop.getKey(), value);
        }
    }

    protected void setBytes(String key, byte[] value) {
        String encoded = value == null ? null : new String(Base64.encodeBase64((byte[])value), Constants.UTF8_CHARSET);
        this.setUnlimitedString(key, encoded);
    }

    private boolean checkType(Class<?> exptected, EProperty actual) {
        if (exptected == null) {
            log.error("Expected class was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (actual == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (actual.getPropType() != EProperty.EPropertyType.GLOBAL) {
            log.warn("Given property {} is of type {}, but {} is expected. Probably wrong property given.", new Object[]{actual.name(), actual.getPropType(), EProperty.EPropertyType.GLOBAL});
        }
        if (exptected == actual.getType()) {
            return true;
        }
        log.error("Property {} is not of type: {}", (Object)actual.name(), (Object)exptected.getSimpleName());
        return false;
    }
}

