/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.mailer;

import java.util.List;
import java.util.regex.Pattern;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.mail.visitor.RegexVisitor;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.LoggerFactory;

public class IgnoreEncryptionDetector {
    private final RegexVisitor visitor;

    private static final Pattern createPattern(String baseUrl) {
        StringBuilder builder = new StringBuilder(baseUrl.length() + 40);
        builder.append("\\Q");
        builder.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            builder.append('/');
        }
        builder.append("passwordreset?token=\\E[0-9a-f]{40}");
        return Pattern.compile(builder.toString());
    }

    public IgnoreEncryptionDetector(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null.");
        }
        this.visitor = new RegexVisitor(IgnoreEncryptionDetector.createPattern(baseUrl));
        this.visitor.setContentType("text/plain");
    }

    public boolean isIgnoreEncryptionEmail(MimeMessage msg) {
        try {
            this.visitor.visit(msg);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not check if message with ID \"" + MessageUtil.getMessageId(msg) + "\" is a password reset request. Error message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return !((List)this.visitor.getResult()).isEmpty();
    }
}

