/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Exception;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ExternalParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ParsingException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1StreamParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLExternal;

public class DERExternalParser
implements ASN1ExternalParser {
    private ASN1StreamParser _parser;

    public DERExternalParser(ASN1StreamParser parser) {
        this._parser = parser;
    }

    public ASN1Encodable readObject() throws IOException {
        return this._parser.readObject();
    }

    public ASN1Primitive getLoadedObject() throws IOException {
        return DERExternalParser.parse(this._parser);
    }

    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
        catch (IllegalArgumentException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
    }

    static DLExternal parse(ASN1StreamParser sp) throws IOException {
        try {
            return new DLExternal(sp.readVector());
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception(e.getMessage(), e);
        }
    }
}

