/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1UTF8String;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERUTF8String;

public class PKIFreeText
extends ASN1Object {
    ASN1Sequence strings;

    private PKIFreeText(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            if (e.nextElement() instanceof ASN1UTF8String) continue;
            throw new IllegalArgumentException("attempt to insert non UTF8 STRING into PKIFreeText");
        }
        this.strings = seq;
    }

    public PKIFreeText(ASN1UTF8String p) {
        this.strings = new DERSequence(p);
    }

    public PKIFreeText(String p) {
        this(new DERUTF8String(p));
    }

    public PKIFreeText(ASN1UTF8String[] strs) {
        this.strings = new DERSequence(strs);
    }

    public PKIFreeText(String[] strs) {
        ASN1EncodableVector v = new ASN1EncodableVector(strs.length);
        for (int i = 0; i < strs.length; ++i) {
            v.add(new DERUTF8String(strs[i]));
        }
        this.strings = new DERSequence(v);
    }

    public static PKIFreeText getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIFreeText.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PKIFreeText getInstance(Object obj) {
        if (obj instanceof PKIFreeText) {
            return (PKIFreeText)obj;
        }
        if (obj != null) {
            return new PKIFreeText(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public int size() {
        return this.strings.size();
    }

    public DERUTF8String getStringAt(int i) {
        ASN1UTF8String stringAt = this.getStringAtUTF8(i);
        return null == stringAt || stringAt instanceof DERUTF8String ? (DERUTF8String)stringAt : new DERUTF8String(stringAt.getString());
    }

    public ASN1UTF8String getStringAtUTF8(int i) {
        return (ASN1UTF8String)this.strings.getObjectAt(i);
    }

    public ASN1Primitive toASN1Primitive() {
        return this.strings;
    }
}

