/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADAlgorithmTags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADUtils;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGHeaderObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class AEADEncDataPacket
extends InputStreamPacket
implements AEADAlgorithmTags,
BCPGHeaderObject {
    private final byte version;
    private final byte algorithm;
    private final byte aeadAlgorithm;
    private final byte chunkSize;
    private final byte[] iv;

    public AEADEncDataPacket(BCPGInputStream in) throws IOException {
        super(in);
        this.version = (byte)in.read();
        if (this.version != 1) {
            throw new IllegalArgumentException("wrong AEAD packet version: " + this.version);
        }
        this.algorithm = (byte)in.read();
        this.aeadAlgorithm = (byte)in.read();
        this.chunkSize = (byte)in.read();
        this.iv = new byte[AEADEncDataPacket.getIVLength(this.aeadAlgorithm)];
        in.readFully(this.iv);
    }

    public AEADEncDataPacket(int algorithm, int aeadAlgorithm, int chunkSize, byte[] iv) {
        super(null);
        this.version = 1;
        this.algorithm = (byte)algorithm;
        this.aeadAlgorithm = (byte)aeadAlgorithm;
        this.chunkSize = (byte)chunkSize;
        this.iv = Arrays.clone(iv);
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte getAEADAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public byte[] getAAData() {
        return AEADEncDataPacket.createAAData(this.getVersion(), this.getAlgorithm(), this.getAEADAlgorithm(), this.getChunkSize());
    }

    private static byte[] createAAData(int version, int symAlgorithm, int aeadAlgorithm, int chunkSize) {
        byte[] aaData = new byte[]{-44, (byte)(version & 0xFF), (byte)(symAlgorithm & 0xFF), (byte)(aeadAlgorithm & 0xFF), (byte)(chunkSize & 0xFF)};
        return aaData;
    }

    public int getType() {
        return 20;
    }

    public void encode(BCPGOutputStream pgOut) throws IOException {
        pgOut.write(1);
        pgOut.write(this.getAlgorithm());
        pgOut.write(this.getAEADAlgorithm());
        pgOut.write(this.getChunkSize());
        pgOut.write(this.iv);
    }

    public static int getIVLength(byte aeadAlgorithm) {
        return AEADUtils.getIVLength(aeadAlgorithm);
    }
}

