/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its.bc;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.ExtendedDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.DSADigestSigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.ECDSASigner;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificate;
import net.savignano.thirdparty.org.bouncycastle.its.bc.BcITSPublicVerificationKey;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ITSContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.oer.OEREncoder;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.VerificationKeyIndicator;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicVerificationKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.template.ieee1609dot2.IEEE1609dot2;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BcITSContentVerifierProvider
implements ITSContentVerifierProvider {
    private final ITSCertificate issuer;
    private final byte[] parentData;
    private final AlgorithmIdentifier digestAlgo;
    private final ECPublicKeyParameters pubParams;
    private final int sigChoice;

    public BcITSContentVerifierProvider(ITSCertificate issuer) throws IOException {
        PublicVerificationKey pvi;
        this.issuer = issuer;
        this.parentData = issuer.getEncoded();
        ToBeSignedCertificate toBeSignedCertificate = issuer.toASN1Structure().getToBeSigned();
        VerificationKeyIndicator vki = toBeSignedCertificate.getVerifyKeyIndicator();
        if (vki.getVerificationKeyIndicator() instanceof PublicVerificationKey) {
            pvi = PublicVerificationKey.getInstance(vki.getVerificationKeyIndicator());
            this.sigChoice = pvi.getChoice();
            switch (pvi.getChoice()) {
                case 0: {
                    this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
                    break;
                }
                case 1: {
                    this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
                    break;
                }
                case 2: {
                    this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown key type");
                }
            }
        } else {
            throw new IllegalStateException("not public verification key");
        }
        this.pubParams = (ECPublicKeyParameters)new BcITSPublicVerificationKey(pvi).getKey();
    }

    public ITSCertificate getAssociatedCertificate() {
        return this.issuer;
    }

    public boolean hasAssociatedCertificate() {
        return this.issuer != null;
    }

    public ContentVerifier get(int verifierAlgorithmIdentifier) throws OperatorCreationException {
        byte[] parentTBSDigest;
        if (this.sigChoice != verifierAlgorithmIdentifier) {
            throw new OperatorCreationException("wrong verifier for algorithm: " + verifierAlgorithmIdentifier);
        }
        final ExtendedDigest digest = BcDefaultDigestProvider.INSTANCE.get(this.digestAlgo);
        final byte[] parentDigest = new byte[digest.getDigestSize()];
        digest.update(this.parentData, 0, this.parentData.length);
        digest.doFinal(parentDigest, 0);
        byte[] byArray = parentTBSDigest = this.issuer.getIssuer().isSelf() ? new byte[digest.getDigestSize()] : null;
        if (parentTBSDigest != null) {
            byte[] enc = OEREncoder.toByteArray(this.issuer.toASN1Structure().getToBeSigned(), IEEE1609dot2.ToBeSignedCertificate.build());
            digest.update(enc, 0, enc.length);
            digest.doFinal(parentTBSDigest, 0);
        }
        final OutputStream os = new OutputStream(){

            public void write(int b) throws IOException {
                digest.update((byte)b);
            }

            public void write(byte[] b) throws IOException {
                digest.update(b, 0, b.length);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                digest.update(b, off, len);
            }
        };
        return new ContentVerifier(){
            final DSADigestSigner signer;
            {
                this.signer = new DSADigestSigner(new ECDSASigner(), BcDefaultDigestProvider.INSTANCE.get(BcITSContentVerifierProvider.this.digestAlgo));
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return null;
            }

            public OutputStream getOutputStream() {
                return os;
            }

            public boolean verify(byte[] expected) {
                byte[] clientCertDigest = new byte[digest.getDigestSize()];
                digest.doFinal(clientCertDigest, 0);
                this.signer.init(false, BcITSContentVerifierProvider.this.pubParams);
                this.signer.update(clientCertDigest, 0, clientCertDigest.length);
                if (parentTBSDigest != null && Arrays.areEqual(clientCertDigest, parentTBSDigest)) {
                    byte[] empty = new byte[digest.getDigestSize()];
                    digest.doFinal(empty, 0);
                    this.signer.update(empty, 0, empty.length);
                } else {
                    this.signer.update(parentDigest, 0, parentDigest.length);
                }
                return this.signer.verifySignature(expected);
            }
        };
    }
}

