/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941.basetypes;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicVerificationKey;

public class PublicKeys
extends ASN1Object {
    private final PublicVerificationKey verificationKey;
    private final PublicEncryptionKey encryptionKey;

    public PublicKeys(PublicVerificationKey verificationKey, PublicEncryptionKey encryptionKey) {
        this.verificationKey = verificationKey;
        this.encryptionKey = encryptionKey;
    }

    public static PublicKeys getInstance(Object o) {
        if (o instanceof PublicKeys) {
            return (PublicKeys)o;
        }
        if (o != null) {
            return new PublicKeys(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    private PublicKeys(ASN1Sequence sequence) {
        if (sequence.size() != 2) {
            throw new IllegalArgumentException("expected sequence size of 2");
        }
        this.verificationKey = PublicVerificationKey.getInstance(sequence.getObjectAt(0));
        this.encryptionKey = OEROptional.getValue(PublicEncryptionKey.class, sequence.getObjectAt(1));
    }

    public PublicVerificationKey getVerificationKey() {
        return this.verificationKey;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.verificationKey, OEROptional.getInstance(this.encryptionKey)});
    }
}

