/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;

public class SymmetricEncryptionKey
extends ASN1Object
implements ASN1Choice {
    public static final int aes128ccm = 0;
    private final int choice;
    private final ASN1Encodable symmetricEncryptionKey;

    public SymmetricEncryptionKey(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.symmetricEncryptionKey = value;
    }

    private SymmetricEncryptionKey(ASN1TaggedObject instance) {
        ASN1OctetString str;
        this.choice = instance.getTagNo();
        if (this.choice == 0) {
            str = DEROctetString.getInstance(instance.getObject());
            if (str.getOctets().length != 16) {
                throw new IllegalArgumentException("aes128ccm string not 16 bytes");
            }
        } else {
            throw new IllegalArgumentException("invalid choice value " + this.choice);
        }
        this.symmetricEncryptionKey = str;
    }

    public static SymmetricEncryptionKey getInstance(Object o) {
        if (o instanceof SymmetricEncryptionKey) {
            return (SymmetricEncryptionKey)o;
        }
        if (o != null) {
            return new SymmetricEncryptionKey(ASN1TaggedObject.getInstance(o));
        }
        return null;
    }

    public static SymmetricEncryptionKey aes128ccm(byte[] octetString) {
        return new SymmetricEncryptionKey(0, new DEROctetString(octetString));
    }

    public static SymmetricEncryptionKey aes128ccm(ASN1OctetString octetString) {
        return new SymmetricEncryptionKey(0, octetString);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getSymmetricEncryptionKey() {
        return this.symmetricEncryptionKey;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.symmetricEncryptionKey);
    }
}

