/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SignatureSubpacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.EmbeddedSignature;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.Exportable;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.Features;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.IssuerFingerprint;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.IssuerKeyID;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.KeyExpirationTime;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.KeyFlags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.NotationData;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.PolicyURI;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.PrimaryUserID;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.Revocable;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.RevocationKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.RevocationReason;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignatureCreationTime;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignatureTarget;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignerUserID;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.TrustSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public class PGPSignatureSubpacketGenerator {
    List packets = new ArrayList();

    public PGPSignatureSubpacketGenerator() {
    }

    public PGPSignatureSubpacketGenerator(PGPSignatureSubpacketVector sigSubV) {
        if (sigSubV != null) {
            for (int i = 0; i != sigSubV.packets.length; ++i) {
                this.packets.add(sigSubV.packets[i]);
            }
        }
    }

    public void setRevocable(boolean isCritical, boolean isRevocable) {
        this.packets.add(new Revocable(isCritical, isRevocable));
    }

    public void setExportable(boolean isCritical, boolean isExportable) {
        this.packets.add(new Exportable(isCritical, isExportable));
    }

    public void setFeature(boolean isCritical, byte feature) {
        this.packets.add(new Features(isCritical, feature));
    }

    public void setTrust(boolean isCritical, int depth, int trustAmount) {
        this.packets.add(new TrustSignature(isCritical, depth, trustAmount));
    }

    public void setKeyExpirationTime(boolean isCritical, long seconds) {
        this.packets.add(new KeyExpirationTime(isCritical, seconds));
    }

    public void setSignatureExpirationTime(boolean isCritical, long seconds) {
        this.packets.add(new SignatureExpirationTime(isCritical, seconds));
    }

    public void setSignatureCreationTime(boolean isCritical, Date date) {
        this.packets.add(new SignatureCreationTime(isCritical, date));
    }

    public void setPreferredHashAlgorithms(boolean isCritical, int[] algorithms) {
        this.packets.add(new PreferredAlgorithms(21, isCritical, algorithms));
    }

    public void setPreferredSymmetricAlgorithms(boolean isCritical, int[] algorithms) {
        this.packets.add(new PreferredAlgorithms(11, isCritical, algorithms));
    }

    public void setPreferredCompressionAlgorithms(boolean isCritical, int[] algorithms) {
        this.packets.add(new PreferredAlgorithms(22, isCritical, algorithms));
    }

    public void setPreferredAEADAlgorithms(boolean isCritical, int[] algorithms) {
        this.packets.add(new PreferredAlgorithms(39, isCritical, algorithms));
    }

    public void addPolicyURI(boolean isCritical, String policyUri) {
        this.packets.add(new PolicyURI(isCritical, policyUri));
    }

    public void setKeyFlags(boolean isCritical, int flags) {
        this.packets.add(new KeyFlags(isCritical, flags));
    }

    public void setSignerUserID(boolean isCritical, String userID) {
        this.addSignerUserID(isCritical, userID);
    }

    public void addSignerUserID(boolean isCritical, String userID) {
        if (userID == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.packets.add(new SignerUserID(isCritical, userID));
    }

    public void setSignerUserID(boolean isCritical, byte[] rawUserID) {
        if (rawUserID == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.packets.add(new SignerUserID(isCritical, false, rawUserID));
    }

    public void setEmbeddedSignature(boolean isCritical, PGPSignature pgpSignature) throws IOException {
        this.addEmbeddedSignature(isCritical, pgpSignature);
    }

    public void addEmbeddedSignature(boolean isCritical, PGPSignature pgpSignature) throws IOException {
        byte[] sig = pgpSignature.getEncoded();
        byte[] data = sig.length - 1 > 256 ? new byte[sig.length - 3] : new byte[sig.length - 2];
        System.arraycopy(sig, sig.length - data.length, data, 0, data.length);
        this.packets.add(new EmbeddedSignature(isCritical, false, data));
    }

    public void setPrimaryUserID(boolean isCritical, boolean isPrimaryUserID) {
        this.packets.add(new PrimaryUserID(isCritical, isPrimaryUserID));
    }

    public void setNotationData(boolean isCritical, boolean isHumanReadable, String notationName, String notationValue) {
        this.addNotationData(isCritical, isHumanReadable, notationName, notationValue);
    }

    public void addNotationData(boolean isCritical, boolean isHumanReadable, String notationName, String notationValue) {
        this.packets.add(new NotationData(isCritical, isHumanReadable, notationName, notationValue));
    }

    public void setRevocationReason(boolean isCritical, byte reason, String description) {
        this.packets.add(new RevocationReason(isCritical, reason, description));
    }

    public void setRevocationKey(boolean isCritical, int keyAlgorithm, byte[] fingerprint) {
        this.addRevocationKey(isCritical, keyAlgorithm, fingerprint);
    }

    public void addRevocationKey(boolean isCritical, int keyAlgorithm, byte[] fingerprint) {
        this.packets.add(new RevocationKey(isCritical, -128, keyAlgorithm, fingerprint));
    }

    public void setIssuerKeyID(boolean isCritical, long keyID) {
        this.packets.add(new IssuerKeyID(isCritical, keyID));
    }

    public void setSignatureTarget(boolean isCritical, int publicKeyAlgorithm, int hashAlgorithm, byte[] hashData) {
        this.packets.add(new SignatureTarget(isCritical, publicKeyAlgorithm, hashAlgorithm, hashData));
    }

    public void setIssuerFingerprint(boolean isCritical, PGPSecretKey secretKey) {
        this.setIssuerFingerprint(isCritical, secretKey.getPublicKey());
    }

    public void setIssuerFingerprint(boolean isCritical, PGPPublicKey publicKey) {
        this.packets.add(new IssuerFingerprint(isCritical, publicKey.getVersion(), publicKey.getFingerprint()));
    }

    public void setIntendedRecipientFingerprint(boolean isCritical, PGPPublicKey publicKey) {
        this.addIntendedRecipientFingerprint(isCritical, publicKey);
    }

    public void addIntendedRecipientFingerprint(boolean isCritical, PGPPublicKey publicKey) {
        this.packets.add(new IntendedRecipientFingerprint(isCritical, publicKey.getVersion(), publicKey.getFingerprint()));
    }

    public void addCustomSubpacket(SignatureSubpacket subpacket) {
        this.packets.add(subpacket);
    }

    public boolean removePacket(SignatureSubpacket packet) {
        return this.packets.remove(packet);
    }

    public boolean hasSubpacket(int type) {
        for (int i = 0; i != this.packets.size(); ++i) {
            if (((SignatureSubpacket)this.packets.get(i)).getType() != type) continue;
            return true;
        }
        return false;
    }

    public SignatureSubpacket[] getSubpackets(int type) {
        ArrayList list = new ArrayList();
        for (int i = 0; i != this.packets.size(); ++i) {
            if (((SignatureSubpacket)this.packets.get(i)).getType() != type) continue;
            list.add(this.packets.get(i));
        }
        return list.toArray(new SignatureSubpacket[0]);
    }

    public PGPSignatureSubpacketVector generate() {
        return new PGPSignatureSubpacketVector(this.packets.toArray(new SignatureSubpacket[this.packets.size()]));
    }
}

