/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.BlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Wrapper;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.X25519Agreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPPad;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.RFC6637Utils;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.CryptlibObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private static final BcPGPKeyConverter KEY_CONVERTER = new BcPGPKeyConverter();
    private final PGPPrivateKey pgpPrivKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pgpPrivKey) {
        this.pgpPrivKey = pgpPrivKey;
    }

    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
        try {
            byte[] secret;
            AsymmetricKeyParameter privKey = KEY_CONVERTER.getPrivateKey(this.pgpPrivKey);
            if (keyAlgorithm != 18) {
                AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(keyAlgorithm);
                BufferedAsymmetricBlockCipher c1 = new BufferedAsymmetricBlockCipher(c);
                c1.init(false, privKey);
                if (keyAlgorithm == 2 || keyAlgorithm == 1) {
                    byte[] bi = secKeyData[0];
                    c1.processBytes(bi, 2, bi.length - 2);
                } else {
                    ElGamalPrivateKeyParameters parms = (ElGamalPrivateKeyParameters)privKey;
                    int size = (parms.getParameters().getP().bitLength() + 7) / 8;
                    byte[] tmp = new byte[size];
                    byte[] bi = secKeyData[0];
                    if (bi.length - 2 > size) {
                        c1.processBytes(bi, 3, bi.length - 3);
                    } else {
                        System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                        c1.processBytes(tmp, 0, tmp.length);
                    }
                    bi = secKeyData[1];
                    for (int i = 0; i != tmp.length; ++i) {
                        tmp[i] = 0;
                    }
                    if (bi.length - 2 > size) {
                        c1.processBytes(bi, 3, bi.length - 3);
                    } else {
                        System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                        c1.processBytes(tmp, 0, tmp.length);
                    }
                }
                return c1.doFinal();
            }
            ECDHPublicBCPGKey ecPubKey = (ECDHPublicBCPGKey)this.pgpPrivKey.getPublicKeyPacket().getKey();
            byte[] enc = secKeyData[0];
            int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
            if (2 + pLen + 1 > enc.length) {
                throw new PGPException("encoded length out of range");
            }
            byte[] pEnc = new byte[pLen];
            System.arraycopy(enc, 2, pEnc, 0, pLen);
            int keyLen = enc[pLen + 2] & 0xFF;
            if (2 + pLen + 1 + keyLen > enc.length) {
                throw new PGPException("encoded length out of range");
            }
            byte[] keyEnc = new byte[keyLen];
            System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyLen);
            if (ecPubKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                if (pEnc.length != 33 || 64 != pEnc[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                X25519PublicKeyParameters ephPub = new X25519PublicKeyParameters(pEnc, 1);
                X25519Agreement agreement = new X25519Agreement();
                agreement.init(privKey);
                secret = new byte[agreement.getAgreementSize()];
                agreement.calculateAgreement(ephPub, secret, 0);
            } else {
                ECDomainParameters ecParameters = ((ECPrivateKeyParameters)privKey).getParameters();
                ECPublicKeyParameters ephPub = new ECPublicKeyParameters(ecParameters.getCurve().decodePoint(pEnc), ecParameters);
                ECDHBasicAgreement agreement = new ECDHBasicAgreement();
                agreement.init(privKey);
                BigInteger S = agreement.calculateAgreement(ephPub);
                secret = BigIntegers.asUnsignedByteArray(agreement.getFieldSize(), S);
            }
            RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(ecPubKey.getHashAlgorithm()), ecPubKey.getSymmetricKeyAlgorithm());
            byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(this.pgpPrivKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator());
            KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(secret, userKeyingMaterial));
            Wrapper c = BcImplProvider.createWrapper(ecPubKey.getSymmetricKeyAlgorithm());
            c.init(false, key);
            return PGPPad.unpadSessionData(c.unwrap(keyEnc, 0, keyEnc.length));
        }
        catch (IOException e) {
            throw new PGPException("exception creating user keying material: " + e.getMessage(), e);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception decrypting session info: " + e.getMessage(), e);
        }
    }

    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }

    public PGPDataDecryptor createDataDecryptor(int aeadAlgorithm, byte[] iv, int chunkSize, int encAlgorithm, byte[] key) throws PGPException {
        return BcUtil.createDataDecryptor(aeadAlgorithm, iv, chunkSize, encAlgorithm, key);
    }
}

