/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParametersHolder;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPPad;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.RFC6637Utils;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.CryptlibObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private static final int X25519_KEY_SIZE = 32;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String providerName) {
        this.contentHelper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    private int getExpectedPayloadSize(PrivateKey key) {
        if (key instanceof DHKey) {
            DHKey k = (DHKey)((Object)key);
            return (k.getParams().getP().bitLength() + 7) / 8;
        }
        if (key instanceof RSAKey) {
            RSAKey k = (RSAKey)((Object)key);
            return (k.getModulus().bitLength() + 7) / 8;
        }
        return -1;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privKey) {
        return new PublicKeyDataDecryptorFactory(){
            final int expectedPayLoadSize;
            {
                this.expectedPayLoadSize = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(privKey);
            }

            public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
                if (keyAlgorithm == 18) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(keyAlgorithm, privKey, this.expectedPayLoadSize, secKeyData);
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }

            public PGPDataDecryptor createDataDecryptor(int aeadAlgorithm, byte[] iv, int chunkSize, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(aeadAlgorithm, iv, chunkSize, encAlgorithm, key);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey privKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
                if (keyAlgorithm == 18) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, privKey, secKeyData);
                }
                PrivateKey jcePrivKey = JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(privKey);
                int expectedPayLoadSize = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(jcePrivKey);
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(keyAlgorithm, jcePrivKey, expectedPayLoadSize, secKeyData);
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }

            public PGPDataDecryptor createDataDecryptor(int aeadAlgorithm, byte[] iv, int chunkSize, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(aeadAlgorithm, iv, chunkSize, encAlgorithm, key);
            }
        };
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter converter, PGPPrivateKey privKey, byte[][] secKeyData) throws PGPException {
        PublicKeyPacket pubKeyData = privKey.getPublicKeyPacket();
        ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
        byte[] enc = secKeyData[0];
        int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
        if (2 + pLen + 1 > enc.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] pEnc = new byte[pLen];
        System.arraycopy(enc, 2, pEnc, 0, pLen);
        int keyLen = enc[pLen + 2] & 0xFF;
        if (2 + pLen + 1 + keyLen > enc.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] keyEnc = new byte[keyLen];
        System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyLen);
        try {
            PublicKey publicKey;
            KeyAgreement agreement;
            if (ecKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                agreement = this.helper.createKeyAgreement(RFC6637Utils.getXDHAlgorithm(pubKeyData));
                KeyFactory keyFact = this.helper.createKeyFactory("XDH");
                if (pEnc.length != 33 || 64 != pEnc[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = keyFact.generatePublic(new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), Arrays.copyOfRange(pEnc, 1, pEnc.length)).getEncoded()));
            } else {
                X9ECParametersHolder x9Params = ECNamedCurveTable.getByOIDLazy(ecKey.getCurveOID());
                ECPoint publicPoint = x9Params.getCurve().decodePoint(pEnc);
                agreement = this.helper.createKeyAgreement(RFC6637Utils.getAgreementAlgorithm(pubKeyData));
                publicKey = converter.getPublicKey(new PGPPublicKey(new PublicKeyPacket(18, new Date(), new ECDHPublicBCPGKey(ecKey.getCurveOID(), publicPoint, (int)ecKey.getHashAlgorithm(), (int)ecKey.getSymmetricKeyAlgorithm())), this.fingerprintCalculator));
            }
            byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(pubKeyData, this.fingerprintCalculator);
            PrivateKey privateKey = converter.getPrivateKey(privKey);
            agreement.init((Key)privateKey, new UserKeyingMaterialSpec(userKeyingMaterial));
            agreement.doPhase(publicKey, true);
            SecretKey key = agreement.generateSecret(RFC6637Utils.getKeyEncryptionOID(ecKey.getSymmetricKeyAlgorithm()).getId());
            Cipher c = this.helper.createKeyWrapper(ecKey.getSymmetricKeyAlgorithm());
            c.init(4, key);
            Key paddedSessionKey = c.unwrap(keyEnc, "Session", 3);
            return PGPPad.unpadSessionData(paddedSessionKey.getEncoded());
        }
        catch (InvalidKeyException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        catch (IOException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
    }

    private void updateWithMPI(Cipher c, int expectedPayloadSize, byte[] encMPI) {
        if (expectedPayloadSize > 0) {
            if (encMPI.length - 2 > expectedPayloadSize) {
                c.update(encMPI, 3, encMPI.length - 3);
            } else {
                if (expectedPayloadSize > encMPI.length - 2) {
                    c.update(new byte[expectedPayloadSize - (encMPI.length - 2)]);
                }
                c.update(encMPI, 2, encMPI.length - 2);
            }
        } else {
            c.update(encMPI, 2, encMPI.length - 2);
        }
    }

    private byte[] decryptSessionData(int keyAlgorithm, PrivateKey privKey, int expectedPayloadSize, byte[][] secKeyData) throws PGPException {
        Cipher c1 = this.helper.createPublicKeyCipher(keyAlgorithm);
        try {
            c1.init(2, privKey);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        if (keyAlgorithm == 2 || keyAlgorithm == 1) {
            this.updateWithMPI(c1, expectedPayloadSize, secKeyData[0]);
        } else {
            this.updateWithMPI(c1, expectedPayloadSize, secKeyData[0]);
            this.updateWithMPI(c1, expectedPayloadSize, secKeyData[1]);
        }
        try {
            return c1.doFinal();
        }
        catch (Exception e) {
            throw new PGPException("exception decrypting session data", e);
        }
    }
}

