/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.operator.jcajce;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.operator.AsymmetricKeyUnwrapper;
import net.savignano.thirdparty.org.bouncycastle.operator.GenericKey;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorException;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JceGenericKey;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.OperatorHelper;

public class JceAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PrivateKey privKey;
    private boolean unwrappedKeyMustBeEncodable;

    public JceAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privKey) {
        super(algorithmIdentifier);
        this.privKey = privKey;
    }

    public JceAsymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setMustProduceEncodableUnwrappedKey(boolean unwrappedKeyMustBeEncodable) {
        this.unwrappedKeyMustBeEncodable = unwrappedKeyMustBeEncodable;
        return this;
    }

    public JceAsymmetricKeyUnwrapper setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            AlgorithmParameters algParams;
            Cipher keyCipher;
            Key sKey;
            block18: {
                sKey = null;
                keyCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
                algParams = this.helper.createAlgorithmParameters(this.getAlgorithmIdentifier());
                try {
                    if (algParams != null && !this.getAlgorithmIdentifier().getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
                        keyCipher.init(4, (Key)this.privKey, algParams);
                    } else {
                        keyCipher.init(4, this.privKey);
                    }
                    sKey = keyCipher.unwrap(encryptedKey, this.helper.getKeyAlgorithmName(encryptedKeyAlgorithm.getAlgorithm()), 3);
                    if (!this.unwrappedKeyMustBeEncodable) break block18;
                    try {
                        byte[] keyBytes = sKey.getEncoded();
                        if (keyBytes == null || keyBytes.length == 0) {
                            sKey = null;
                        }
                    }
                    catch (Exception e) {
                        sKey = null;
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (ProviderException providerException) {
                    // empty catch block
                }
            }
            if (sKey == null) {
                if (algParams != null) {
                    keyCipher.init(2, (Key)this.privKey, algParams);
                } else {
                    keyCipher.init(2, this.privKey);
                }
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), encryptedKeyAlgorithm.getAlgorithm().getId());
            }
            return new JceGenericKey(encryptedKeyAlgorithm, sKey);
        }
        catch (InvalidKeyException e) {
            throw new OperatorException("key invalid: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new OperatorException("illegal blocksize: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new OperatorException("bad padding: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new OperatorException("invalid algorithm parameters: " + e.getMessage(), e);
        }
    }
}

