/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.asn1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class FalconPublicKey
extends ASN1Object {
    private byte[] h;

    public FalconPublicKey(byte[] h) {
        this.h = h;
    }

    public byte[] getH() {
        return this.h;
    }

    public FalconPublicKey(ASN1Sequence seq) {
        this.h = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DEROctetString(this.h));
        return new DERSequence(v);
    }

    public static FalconPublicKey getInstance(Object o) {
        if (o instanceof FalconPublicKey) {
            return (FalconPublicKey)o;
        }
        if (o != null) {
            return new FalconPublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

