/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber;

import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class KyberPrivateKeyParameters
extends KyberKeyParameters {
    final byte[] s;
    final byte[] hpk;
    final byte[] nonce;
    final byte[] t;
    final byte[] rho;

    public KyberPrivateKeyParameters(KyberParameters params, byte[] s, byte[] hpk, byte[] nonce, byte[] t, byte[] rho) {
        super(true, params);
        this.s = Arrays.clone(s);
        this.hpk = Arrays.clone(hpk);
        this.nonce = Arrays.clone(nonce);
        this.t = Arrays.clone(t);
        this.rho = Arrays.clone(rho);
    }

    public byte[] getT() {
        return Arrays.clone(this.t);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getPrivateKey() {
        return Arrays.concatenate(this.s, this.getPublicKey(), this.hpk, this.nonce);
    }

    public byte[] getEncoded() {
        return this.getPrivateKey();
    }

    public byte[] getPublicKey() {
        return Arrays.concatenate(this.t, this.rho);
    }

    public byte[] getS() {
        return Arrays.clone(this.s);
    }

    public byte[] getHPK() {
        return Arrays.clone(this.hpk);
    }

    public byte[] getNonce() {
        return Arrays.clone(this.nonce);
    }
}

