/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo.FrodoEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;

public class FrodoKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public FrodoKEMGenerator(SecureRandom random) {
        this.sr = random;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        FrodoPublicKeyParameters key = (FrodoPublicKeyParameters)recipientKey;
        FrodoEngine engine = key.getParameters().getEngine();
        byte[] cipher_text = new byte[engine.getCipherTextSize()];
        byte[] sessionKey = new byte[engine.getSessionKeySize()];
        engine.kem_enc(cipher_text, sessionKey, key.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(sessionKey, cipher_text);
    }
}

