/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.gemss;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.MessageSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.gemss.GeMSSEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.gemss.GeMSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.gemss.GeMSSPublicKeyParameters;

public class GeMSSSigner
implements MessageSigner {
    private GeMSSPrivateKeyParameters privKey;
    private GeMSSPublicKeyParameters pubKey;
    private SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                this.privKey = (GeMSSPrivateKeyParameters)((ParametersWithRandom)param).getParameters();
                this.random = ((ParametersWithRandom)param).getRandom();
            } else {
                this.privKey = (GeMSSPrivateKeyParameters)param;
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        } else {
            this.pubKey = (GeMSSPublicKeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        GeMSSEngine engine = this.privKey.getParameters().getEngine();
        int SIZE_SIGN_HFE = engine.HFEnv + (engine.NB_ITE - 1) * (engine.HFEnv - engine.HFEm) + 7 >>> 3;
        byte[] sm8 = new byte[message.length + SIZE_SIGN_HFE];
        System.arraycopy(message, 0, sm8, SIZE_SIGN_HFE, message.length);
        engine.signHFE_FeistelPatarin(this.random, sm8, message, 0, message.length, this.privKey.sk);
        return sm8;
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        GeMSSEngine engine = this.pubKey.getParameters().getEngine();
        int ret = engine.crypto_sign_open(this.pubKey.getPK(), message, signature);
        return ret != 0;
    }
}

