/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime;

import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.Utils;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class NTRULPRimeKEMExtractor
implements EncapsulatedSecretExtractor {
    private final NTRULPRimePrivateKeyParameters privateKey;

    public NTRULPRimeKEMExtractor(NTRULPRimePrivateKeyParameters privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] extractSecret(byte[] encapsulation) {
        NTRULPRimeParameters params = this.privateKey.getParameters();
        int p = params.getP();
        int q = params.getQ();
        int w = params.getW();
        int roundedPolynomialBytes = params.getRoundedPolynomialBytes();
        int tau0 = params.getTau0();
        int tau1 = params.getTau1();
        int tau2 = params.getTau2();
        int tau3 = params.getTau3();
        byte[] a = new byte[p];
        Utils.getDecodedSmallPolynomial(a, this.privateKey.getEncoded(), p);
        byte[] encB = new byte[roundedPolynomialBytes];
        System.arraycopy(encapsulation, 0, encB, 0, roundedPolynomialBytes);
        short[] B = new short[p];
        Utils.getRoundedDecodedPolynomial(B, encB, p, q);
        byte[] encT = new byte[128];
        System.arraycopy(encapsulation, roundedPolynomialBytes, encT, 0, encT.length);
        byte[] T = new byte[256];
        Utils.getTopDecodedPolynomial(T, encT);
        short[] aB = new short[p];
        Utils.multiplicationInRQ(aB, B, a, p, q);
        byte[] r = new byte[256];
        Utils.right(r, aB, T, q, w, tau2, tau3);
        byte[] encR = new byte[32];
        Utils.getEncodedInputs(encR, r);
        byte[] encA = new byte[params.getPublicKeyBytes() - 32];
        System.arraycopy(this.privateKey.getPk(), 32, encA, 0, encA.length);
        short[] A = new short[p];
        Utils.getRoundedDecodedPolynomial(A, encA, p, q);
        byte[] seed = new byte[32];
        System.arraycopy(this.privateKey.getPk(), 0, seed, 0, seed.length);
        short[] G = new short[p];
        Utils.generatePolynomialInRQFromSeed(G, seed, p, q);
        byte[] hsPrefix = new byte[]{5};
        byte[] hsHash = Utils.getHashWithPrefix(hsPrefix, encR);
        byte[] hs = Arrays.copyOfRange(hsHash, 0, hsHash.length / 2);
        int[] L = new int[p];
        Utils.expand(L, hs);
        byte[] b = new byte[p];
        Utils.sortGenerateShortPolynomial(b, L, p, w);
        short[] bG = new short[p];
        Utils.multiplicationInRQ(bG, G, b, p, q);
        short[] Bnew = new short[p];
        Utils.roundPolynomial(Bnew, bG);
        byte[] encBnew = new byte[roundedPolynomialBytes];
        Utils.getRoundedEncodedPolynomial(encBnew, Bnew, p, q);
        short[] bA = new short[p];
        Utils.multiplicationInRQ(bA, A, b, p, q);
        byte[] Tnew = new byte[256];
        Utils.top(Tnew, bA, r, q, tau0, tau1);
        byte[] encTnew = new byte[128];
        Utils.getTopEncodedPolynomial(encTnew, T);
        byte[] hcInput = new byte[encR.length + this.privateKey.getHash().length];
        System.arraycopy(encR, 0, hcInput, 0, encR.length);
        System.arraycopy(this.privateKey.getHash(), 0, hcInput, encR.length, this.privateKey.getHash().length);
        byte[] hcPrefix = new byte[]{2};
        byte[] hc = Utils.getHashWithPrefix(hcPrefix, hcInput);
        byte[] ct = new byte[encB.length + encT.length + hc.length / 2];
        System.arraycopy(encB, 0, ct, 0, encB.length);
        System.arraycopy(encT, 0, ct, encB.length, encT.length);
        System.arraycopy(hc, 0, ct, encB.length + encT.length, hc.length / 2);
        int mask = Arrays.areEqual(encapsulation, ct) ? 0 : -1;
        Utils.updateDiffMask(encR, this.privateKey.getRho(), mask);
        byte[] ssInput = new byte[encR.length + ct.length];
        System.arraycopy(encR, 0, ssInput, 0, encR.length);
        System.arraycopy(ct, 0, ssInput, encR.length, ct.length);
        byte[] ssPrefix = new byte[]{1};
        byte[] ssHash = Utils.getHashWithPrefix(ssPrefix, ssInput);
        return Arrays.copyOfRange(ssHash, 0, params.getSessionKeySize() / 8);
    }

    public int getEncapsulationLength() {
        return this.privateKey.getParameters().getRoundedPolynomialBytes() + 128 + 32;
    }
}

