/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.gmss.util;

import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] seed0, Digest digest, int w) {
        this.w = w;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.messagesize = ((this.mdsize << 3) + w - 1) / w;
        this.checksumsize = this.getLog((this.messagesize << w) + 1);
        this.keysize = this.messagesize + (this.checksumsize + w - 1) / w;
        this.privateKeyOTS = new byte[this.keysize][];
        byte[] dummy = new byte[this.mdsize];
        System.arraycopy(seed0, 0, dummy, 0, dummy.length);
        for (int i = 0; i < this.keysize; ++i) {
            this.privateKeyOTS[i] = this.gmssRandom.nextSeed(dummy);
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        byte[] buf = new byte[this.keysize * this.mdsize];
        int pos = 0;
        int rounds = (1 << this.w) - 1;
        for (int i = 0; i < this.keysize; ++i) {
            this.hashPrivateKeyBlock(i, rounds, buf, pos);
            pos += this.mdsize;
        }
        this.messDigestOTS.update(buf, 0, buf.length);
        byte[] tmp = new byte[this.mdsize];
        this.messDigestOTS.doFinal(tmp, 0);
        return tmp;
    }

    public byte[] getSignature(byte[] message) {
        byte[] sign;
        block18: {
            long test8;
            int j;
            int ii;
            long big8;
            int rest;
            int s;
            int c;
            int counter;
            byte[] hash;
            block19: {
                int j2;
                long big82;
                int i;
                int test;
                block17: {
                    int i2;
                    sign = new byte[this.keysize * this.mdsize];
                    hash = new byte[this.mdsize];
                    counter = 0;
                    c = 0;
                    test = 0;
                    this.messDigestOTS.update(message, 0, message.length);
                    this.messDigestOTS.doFinal(hash, 0);
                    if (8 % this.w != 0) break block17;
                    int d = 8 / this.w;
                    int k = (1 << this.w) - 1;
                    for (i2 = 0; i2 < hash.length; ++i2) {
                        for (int j3 = 0; j3 < d; ++j3) {
                            test = hash[i2] & k;
                            c += test;
                            this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                            hash[i2] = (byte)(hash[i2] >>> this.w);
                            ++counter;
                        }
                    }
                    c = (this.messagesize << this.w) - c;
                    for (i2 = 0; i2 < this.checksumsize; i2 += this.w) {
                        test = c & k;
                        this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                        c >>>= this.w;
                        ++counter;
                    }
                    break block18;
                }
                if (this.w >= 8) break block19;
                int d = this.mdsize / this.w;
                int k = (1 << this.w) - 1;
                int ii2 = 0;
                for (i = 0; i < d; ++i) {
                    int j4;
                    big82 = 0L;
                    for (j4 = 0; j4 < this.w; ++j4) {
                        big82 ^= (long)((hash[ii2] & 0xFF) << (j4 << 3));
                        ++ii2;
                    }
                    for (j4 = 0; j4 < 8; ++j4) {
                        test = (int)big82 & k;
                        c += test;
                        this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                        big82 >>>= this.w;
                        ++counter;
                    }
                }
                d = this.mdsize % this.w;
                big82 = 0L;
                for (j2 = 0; j2 < d; ++j2) {
                    big82 ^= (long)((hash[ii2] & 0xFF) << (j2 << 3));
                    ++ii2;
                }
                d <<= 3;
                for (j2 = 0; j2 < d; j2 += this.w) {
                    test = (int)big82 & k;
                    c += test;
                    this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                    big82 >>>= this.w;
                    ++counter;
                }
                c = (this.messagesize << this.w) - c;
                for (i = 0; i < this.checksumsize; i += this.w) {
                    test = c & k;
                    this.hashPrivateKeyBlock(counter, test, sign, counter * this.mdsize);
                    c >>>= this.w;
                    ++counter;
                }
                break block18;
            }
            if (this.w >= 57) break block18;
            int d = (this.mdsize << 3) - this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[this.mdsize];
            int r = 0;
            while (r <= d) {
                s = r >>> 3;
                rest = r % 8;
                int f = (r += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                for (j = s; j < f; ++j) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c = (int)((long)c + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                for (test8 = (big8 >>>= rest) & (long)k; test8 > 0L; --test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            s = r >>> 3;
            if (s < this.mdsize) {
                rest = r % 8;
                big8 = 0L;
                ii = 0;
                for (j = s; j < this.mdsize; ++j) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c = (int)((long)c + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                for (test8 = (big8 >>>= rest) & (long)k; test8 > 0L; --test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            c = (this.messagesize << this.w) - c;
            for (int i = 0; i < this.checksumsize; i += this.w) {
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                for (test8 = (long)(c & k); test8 > 0L; --test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                c >>>= this.w;
                ++counter;
            }
        }
        return sign;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i = 2;
        while (i < intValue) {
            i <<= 1;
            ++log;
        }
        return log;
    }

    private void hashPrivateKeyBlock(int index, int rounds, byte[] buf, int off) {
        if (rounds < 1) {
            System.arraycopy(this.privateKeyOTS[index], 0, buf, off, this.mdsize);
        } else {
            this.messDigestOTS.update(this.privateKeyOTS[index], 0, this.mdsize);
            this.messDigestOTS.doFinal(buf, off);
            while (--rounds > 0) {
                this.messDigestOTS.update(buf, off, this.mdsize);
                this.messDigestOTS.doFinal(buf, off);
            }
        }
    }
}

