/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.qtesla;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLASecurityCategory;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.qtesla.QTesla1p;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.qtesla.QTesla3p;

public final class QTESLAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private int securityCategory;
    private SecureRandom secureRandom;

    public void init(KeyGenerationParameters param) {
        QTESLAKeyGenerationParameters parameters = (QTESLAKeyGenerationParameters)param;
        this.secureRandom = parameters.getRandom();
        this.securityCategory = parameters.getSecurityCategory();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] privateKey = this.allocatePrivate(this.securityCategory);
        byte[] publicKey = this.allocatePublic(this.securityCategory);
        switch (this.securityCategory) {
            case 5: {
                QTesla1p.generateKeyPair(publicKey, privateKey, this.secureRandom);
                break;
            }
            case 6: {
                QTesla3p.generateKeyPair(publicKey, privateKey, this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.securityCategory);
            }
        }
        return new AsymmetricCipherKeyPair(new QTESLAPublicKeyParameters(this.securityCategory, publicKey), new QTESLAPrivateKeyParameters(this.securityCategory, privateKey));
    }

    private byte[] allocatePrivate(int securityCategory) {
        return new byte[QTESLASecurityCategory.getPrivateSize(securityCategory)];
    }

    private byte[] allocatePublic(int securityCategory) {
        return new byte[QTESLASecurityCategory.getPublicSize(securityCategory)];
    }
}

