/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.sike;

import java.util.Properties;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;

abstract class Internal {
    protected static final int RADIX = 64;
    protected static final int LOG2RADIX = 6;
    protected int CRYPTO_PUBLICKEYBYTES;
    protected int CRYPTO_CIPHERTEXTBYTES;
    protected int CRYPTO_BYTES;
    protected int CRYPTO_SECRETKEYBYTES;
    protected int NWORDS_FIELD;
    protected int PRIME_ZERO_WORDS;
    protected int NBITS_FIELD;
    protected int MAXBITS_FIELD;
    protected int MAXWORDS_FIELD;
    protected int NWORDS64_FIELD;
    protected int NBITS_ORDER;
    protected int NWORDS_ORDER;
    protected int NWORDS64_ORDER;
    protected int MAXBITS_ORDER;
    protected int ALICE;
    protected int BOB;
    protected int OALICE_BITS;
    protected int OBOB_BITS;
    protected int OBOB_EXPON;
    protected int MASK_ALICE;
    protected int MASK_BOB;
    protected int PARAM_A;
    protected int PARAM_C;
    protected int MAX_INT_POINTS_ALICE;
    protected int MAX_INT_POINTS_BOB;
    protected int MAX_Alice;
    protected int MAX_Bob;
    protected int MSG_BYTES;
    protected int SECRETKEY_A_BYTES;
    protected int SECRETKEY_B_BYTES;
    protected int FP2_ENCODED_BYTES;
    protected boolean COMPRESS;
    protected int MASK2_BOB;
    protected int MASK3_BOB;
    protected int ORDER_A_ENCODED_BYTES;
    protected int ORDER_B_ENCODED_BYTES;
    protected int PARTIALLY_COMPRESSED_CHUNK_CT;
    protected int COMPRESSED_CHUNK_CT;
    protected int UNCOMPRESSEDPK_BYTES;
    protected int TABLE_R_LEN;
    protected int TABLE_V_LEN;
    protected int TABLE_V3_LEN;
    protected int W_2;
    protected int W_3;
    protected int ELL2_W;
    protected int ELL3_W;
    protected int ELL2_EMODW;
    protected int ELL3_EMODW;
    protected int DLEN_2;
    protected int DLEN_3;
    protected int PLEN_2;
    protected int PLEN_3;
    protected long[] PRIME;
    protected long[] PRIMEx2;
    protected long[] PRIMEx4;
    protected long[] PRIMEp1;
    protected long[] PRIMEx16p;
    protected long[] PRIMEp1x64;
    protected long[] Alice_order;
    protected long[] Bob_order;
    protected long[] A_gen;
    protected long[] B_gen;
    protected long[] Montgomery_R2;
    protected long[] Montgomery_one;
    protected int[] strat_Alice;
    protected int[] strat_Bob;
    protected long[] XQB3;
    protected long[] A_basis_zero;
    protected long[] B_basis_zero;
    protected long[] B_gen_3_tors;
    protected long[] g_R_S_im;
    protected long[] g_phiR_phiS_re;
    protected long[] g_phiR_phiS_im;
    protected long[] Montgomery_R;
    protected long[] Montgomery_RB1;
    protected long[] Montgomery_RB2;
    protected long[] threeinv;
    protected int[] ph2_path;
    protected int[] ph3_path;
    protected long[] u_entang;
    protected long[] u0_entang;
    protected long[][] table_r_qr;
    protected long[][] table_r_qnr;
    protected long[][] table_v_qr;
    protected long[][] table_v_qnr;
    protected long[][][] v_3_torsion;
    protected long[] T_tate3;
    protected long[] T_tate2_firststep_P;
    protected long[] T_tate2_P;
    protected long[] T_tate2_firststep_Q;
    protected long[] T_tate2_Q;
    protected long[] ph2_T;
    protected long[] ph2_T1;
    protected long[] ph2_T2;
    protected long[] ph3_T;
    protected long[] ph3_T1;
    protected long[] ph3_T2;

    Internal() {
    }

    protected static int[] ReadIntsFromProperty(Properties props, String key, int intSize) {
        int[] ints = new int[intSize];
        String s = props.getProperty(key);
        String[] vals = s.split(",");
        for (int i = 0; i != vals.length; ++i) {
            ints[i] = Integer.parseInt(vals[i]);
        }
        return ints;
    }

    protected static long[] ReadFromProperty(Properties props, String key, int longSize) {
        String s = props.getProperty(key);
        s = s.replaceAll(",", "");
        byte[] bytes = Hex.decode(s);
        long[] longs = new long[longSize];
        for (int i = 0; i < bytes.length / 8; ++i) {
            longs[i] = Pack.bigEndianToLong(bytes, i * 8);
        }
        return longs;
    }

    protected static long[][] ReadFromProperty(Properties props, String key, int d1Size, int d2Size) {
        String s = props.getProperty(key);
        s = s.replaceAll(",", "");
        byte[] bytes = Hex.decode(s);
        long[][] longs = new long[d1Size][d2Size];
        for (int x = 0; x < bytes.length / 8; ++x) {
            int i = x / d2Size;
            int j = x % d2Size;
            longs[i][j] = Pack.bigEndianToLong(bytes, x * 8);
        }
        return longs;
    }

    protected static long[][][] ReadFromProperty(Properties props, String key, int d1Size, int d2Size, int d3Size) {
        String s = props.getProperty(key);
        s = s.replaceAll(",", "");
        byte[] bytes = Hex.decode(s);
        long[][][] longs = new long[d1Size][d2Size][d3Size];
        for (int x = 0; x < bytes.length / 8; ++x) {
            int i = x / (d2Size * d3Size);
            int j = x % (d2Size * d3Size) / d3Size;
            int k = x % d3Size;
            longs[i][j][k] = Pack.bigEndianToLong(bytes, x * 8);
        }
        return longs;
    }
}

