/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyBoxLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.CertificateBlob;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;

public class SmimeKeyBoxLoader
extends AKeyBoxLoader<SmimeEncryptionKey, String, CertificateBlob> {
    private boolean ignoreCriticalExtension;

    public SmimeKeyBoxLoader(KeyBox keyBox) {
        super(keyBox, BlobType.X509_BLOB);
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimeEncryptionKey loadKeyFromBlob(CertificateBlob blob, String email) throws Exception {
        X509Certificate cert = SmimeUtil.createCertificate(blob.getEncodedCertificate());
        if (!SmimeUtil.isCertForEmail(cert, email) || !this.isIgnoreCriticalExtension() && !SmimeUtil.isCertCriticalExtensionSatisfied(cert)) {
            return null;
        }
        SmimeEncryptionKey key = new SmimeEncryptionKey(cert);
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeEncryptionKey(validity, this.getKeySource());
    }

    @Override
    public int compare(SmimeEncryptionKey o1, SmimeEncryptionKey o2) {
        int compared = super.compare(o1, o2);
        if (compared != 0) {
            return compared;
        }
        return o1.isValid() ? SmimeUtil.getCertificateComparator().compare(o1.getKey(), o2.getKey()) : 0;
    }

    public boolean isIgnoreCriticalExtension() {
        return this.ignoreCriticalExtension;
    }

    public void setIgnoreCriticalExtension(boolean ignoreCriticalExtension) {
        this.ignoreCriticalExtension = ignoreCriticalExtension;
    }
}

