/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.AMailerVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketMailerVersion
extends AMailerVersion {
    private static final Logger log = LoggerFactory.getLogger(BitbucketMailerVersion.class);
    private final MailService service;
    private final String serverEmail;

    public BitbucketMailerVersion(MailService service, String serverEmail, ISnotifyAppProperties appProps) {
        super(appProps);
        this.service = service;
        this.serverEmail = serverEmail;
        if (service == null) {
            throw new IllegalArgumentException("Mail Service must not be null.");
        }
    }

    @Override
    protected void sendInternalMail() {
        if (!this.service.isHostConfigured() || this.serverEmail == null) {
            log.warn("Cannot check if correct mailer library for S/Notify is installed. Please configure an outgoing SMTP mail server, so S/Notify can automatically check if the GUI plugin and Mailer library are compatible with each other.");
            return;
        }
        log.debug("Sending internal email to check S/Notify mailer library version. Email: {}", (Object)this.serverEmail);
        this.service.submit(this.createMsg());
        try {
            for (int i = 0; i < 10; ++i) {
                log.debug("Sleeping for 500ms, waiting for S/Notify mailer library version detection to happen.");
                Thread.sleep(500L);
                if (!this.getAppProps().hasKey(EProperty.MAILER_VERSION)) continue;
                log.debug("S/Notify mailer library version detection successfully finished.");
                break;
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private MailMessage createMsg() {
        MailMessage.Builder builder = new MailMessage.Builder();
        builder.to(new String[]{this.serverEmail});
        builder.subject("S/Notify test email");
        builder.text(this.createHtmlContent());
        builder.header("Content-Type", "text/html; charset=UTF-8");
        builder.header("X-Do-Not-Send", Boolean.TRUE.toString());
        return builder.build();
    }
}

