/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui;

import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import net.savignano.cryptography.version.NormalizedVersion;
import net.savignano.snotify.atlassian.gui.APluginListener;
import net.savignano.snotify.bitbucket.common.BitbucketConstants;
import net.savignano.snotify.bitbucket.gui.BitbucketMailerVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class BitbucketPluginListener
extends APluginListener {
    private static final Logger log = LoggerFactory.getLogger(BitbucketPluginListener.class);
    @Autowired
    @ComponentImport
    private ApplicationPropertiesService appProperties;
    @Autowired
    @ComponentImport
    private MailService service;

    @Override
    protected void setMailerVersion() {
        BitbucketMailerVersion version = new BitbucketMailerVersion(this.service, this.appProperties.getServerEmailAddress(), this.getAppProps());
        version.setAtlassianUrl(((ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class)).getBaseUrl().toString());
        version.setProductInfo(BitbucketConstants.PRODUCT_INFORMATION);
        version.getVersion();
    }

    @Override
    protected boolean checkSignature() {
        NormalizedVersion bitbucketVersion = new NormalizedVersion(this.appProperties.getBuildVersion());
        if (bitbucketVersion.isLowerThan(new NormalizedVersion(7, 14))) {
            log.warn("Bitbucket version {} detected. Skipping signature check.", (Object)bitbucketVersion);
            return true;
        }
        return super.checkSignature();
    }

    @Override
    protected void createCache() {
    }

    @Override
    protected void destroyCache() {
    }
}

