/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.SupportBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusDisplay;
import net.savignano.snotify.bitbucket.gui.servlet.AdminSettingsServlet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtendedSettingsServlet
extends AdminSettingsServlet {
    private static final long serialVersionUID = -4743695740528601285L;
    private static final String ADD_PARAM = "Add";
    private static final String UPDATE_PARAM = "Update";
    private static final String DELETE_PARAM = "Delete";
    private static final String SUPPORT_PARAM = "Support";
    private static final String KEY_PARAM = "key";
    private static final String VALUE_PARAM = "value";
    private static final String ADD_KEY_KEY = "key";
    private static final String ADD_VALUE_KEY = "value";
    @Autowired
    @ComponentImport
    private PluginLicenseManager licenseManager;

    public ExtendedSettingsServlet() {
        super("extended-settings");
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter(SUPPORT_PARAM) != null) {
            this.webSudoProceed(() -> this.support(resp), req, resp);
        } else {
            super.doGet(req, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasMatchinXsrfToken(req)) {
            this.renderXsrfError(req, resp);
            return;
        }
        this.webSudoProceed(() -> {
            if (req.getParameter(ADD_PARAM) != null) {
                this.add(req, resp);
            } else if (req.getParameter(UPDATE_PARAM) != null) {
                this.update(req, resp);
            } else if (req.getParameter(DELETE_PARAM) != null) {
                this.delete(req, resp);
            } else {
                this.getLog().error("Unknonw post behaviour detected.");
                resp.sendError(400);
            }
        }, req, resp);
    }

    @Override
    protected Map<String, Object> createRendererData(HttpServletRequest req) {
        Map<String, Object> renderData = super.createRendererData(req);
        renderData.put("key", "");
        renderData.put("value", "");
        return renderData;
    }

    private void add(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderingException {
        String key = StringUtils.stripToNull((String)req.getParameter("key"));
        String value = StringUtils.stripToNull((String)req.getParameter("value"));
        Map<String, Object> renderData = this.createRendererData(req);
        if (key == null || value == null) {
            this.getLog().debug("Key or Value is considered empty. Tweak will not be added.");
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.missingKeyValue.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.missingKeyValue.message", key);
            String errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            renderData.put("errorMessageHtml", errorMessage);
            if (key != null) {
                renderData.put("key", key);
            }
            if (value != null) {
                renderData.put("value", value);
            }
            this.renderInput(resp, renderData);
            return;
        }
        this.getLog().debug("Adding key/value pair to tweaks: {} = {}", (Object)key, (Object)value);
        this.setProperty(key, value, renderData);
        this.renderInput(resp, renderData);
    }

    private void update(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderingException {
        String key = StringUtils.stripToNull((String)req.getParameter("key"));
        String value = StringUtils.stripToNull((String)req.getParameter("value"));
        Map<String, Object> renderData = this.createRendererData(req);
        if (key == null || value == null) {
            this.getLog().debug("Key or Value is considered empty. Tweak will not be updated.");
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.missingKeyValue.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.missingKeyValue.message", key);
            String errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            renderData.put("errorMessageHtml", errorMessage);
            this.renderInput(resp, renderData);
            return;
        }
        this.getLog().debug("Updating value of tweak: {} = {}", (Object)key, (Object)value);
        this.setProperty(key, value, renderData);
        this.renderInput(resp, renderData);
    }

    private void setProperty(String key, String value, Map<String, Object> renderData) {
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (!prop.isPresent()) {
            this.getLog().debug("Key {} does not represent a tweak.", (Object)key);
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.notAProperty.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.notAProperty.message", key);
            String errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            renderData.put("errorMessageHtml", errorMessage);
            renderData.put("key", key);
            renderData.put("value", value);
            return;
        }
        ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), value);
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.put(key, value);
        this.setUsedTweaks(tweaks);
        renderData.put("showUpdated", true);
    }

    private void delete(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderingException {
        String key = StringUtils.stripToNull((String)req.getParameter("key"));
        Map<String, Object> renderData = this.createRendererData(req);
        if (key == null) {
            this.getLog().debug("Key is considered empty. Tweak will not be removed.");
            this.renderInput(resp, renderData);
            return;
        }
        this.getLog().debug("Removing key from tweaks: {}", (Object)key);
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (prop.isPresent()) {
            ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), null);
        } else {
            this.getLog().debug("Key {} does not represent a tweak.", (Object)key);
        }
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.remove(key);
        this.setUsedTweaks(tweaks);
        renderData.put("showUpdated", true);
        this.renderInput(resp, renderData);
    }

    private void support(HttpServletResponse resp) throws IOException, RenderingException {
        this.getLog().debug("Creating support file.");
        String data = this.createSupportData();
        byte[] contents = data.getBytes(Constants.UTF8_CHARSET);
        resp.addHeader("Content-Type", "text/plain; charset=UTF-8");
        resp.addHeader("Content-Length", String.valueOf(contents.length));
        resp.addHeader("Cache-Control", "no-cache");
        resp.addHeader("Pragma", "no-cache");
        resp.addHeader("Expires", "-1");
        resp.addHeader("Content-Disposition", "attachment; filename=\"snotify-support.txt\"");
        resp.getWriter().append(data);
        resp.getWriter().flush();
    }

    private String createSupportData() {
        Supplier<String> platform = () -> {
            ApplicationPropertiesService appService = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
            return "Bitbucket " + appService.getBuildVersion();
        };
        return SupportBuilder.create().includeLicenseId(this.licenseManager).includePlatform(platform).includeProperties(this.getAppProps()).includeSecurityProvider(SecurityUtil.getProvider()).build();
    }

    public Collection<Map.Entry<String, String>> getTweakEntries() {
        return this.getUsedTweaks().entrySet();
    }

    private Map<String, String> getUsedTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.getAppProps().getUnlimitedString(EProperty.TWEAK_OVERVIEW);
        if (tweakString != null) {
            for (String tweak : tweakString.split("\\;")) {
                Optional<EProperty> prop = EProperty.getProperty("tweak." + tweak);
                if (prop.isPresent()) {
                    tweaks.put(tweak, ((ASnotifyAppProperties)this.getAppProps()).getAsString(prop.get()));
                    continue;
                }
                this.getLog().info("Key {} is not considered a tweak. It will be skipped.");
            }
        }
        return tweaks;
    }

    private void setUsedTweaks(Map<String, String> tweaks) {
        if (tweaks == null || tweaks.isEmpty()) {
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : tweaks.entrySet()) {
                builder.append(entry.getKey());
                builder.append(';');
            }
            builder.deleteCharAt(builder.length() - 1);
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, builder.toString());
        }
    }
}

