/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.x500.style;

public class X500NameTokenizer {
    private final String value;
    private final char separator;
    private int index;

    public X500NameTokenizer(String oid) {
        this(oid, ',');
    }

    public X500NameTokenizer(String oid, char separator) {
        if (oid == null) {
            throw new NullPointerException();
        }
        if (separator == '\"' || separator == '\\') {
            throw new IllegalArgumentException("reserved separator character");
        }
        this.value = oid;
        this.separator = separator;
        this.index = oid.length() < 1 ? 0 : -1;
    }

    public boolean hasMoreTokens() {
        return this.index < this.value.length();
    }

    public String nextToken() {
        if (this.index >= this.value.length()) {
            return null;
        }
        boolean quoted = false;
        boolean escaped = false;
        int beginIndex = this.index + 1;
        while (++this.index < this.value.length()) {
            char c = this.value.charAt(this.index);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\"') {
                quoted = !quoted;
                continue;
            }
            if (quoted) continue;
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != this.separator) continue;
            return this.value.substring(beginIndex, this.index);
        }
        if (escaped || quoted) {
            throw new IllegalArgumentException("badly formatted directory string");
        }
        return this.value.substring(beginIndex, this.index);
    }
}

