/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UserAttributeSubpacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UserAttributeSubpacketTags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.attr.ImageAttribute;

public class UserAttributeSubpacketInputStream
extends InputStream
implements UserAttributeSubpacketTags {
    InputStream in;

    public UserAttributeSubpacketInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    private void readFully(byte[] buf, int off, int len) throws IOException {
        if (len > 0) {
            int b = this.read();
            if (b < 0) {
                throw new EOFException();
            }
            buf[off] = (byte)b;
            ++off;
            --len;
        }
        while (len > 0) {
            int l = this.in.read(buf, off, len);
            if (l < 0) {
                throw new EOFException();
            }
            off += l;
            len -= l;
        }
    }

    public UserAttributeSubpacket readPacket() throws IOException {
        int l = this.read();
        int bodyLen = 0;
        boolean longLength = false;
        if (l < 0) {
            return null;
        }
        if (l < 192) {
            bodyLen = l;
        } else if (l <= 223) {
            bodyLen = (l - 192 << 8) + this.in.read() + 192;
        } else if (l == 255) {
            bodyLen = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
            longLength = true;
        } else {
            throw new IOException("unrecognised length reading user attribute sub packet");
        }
        int tag = this.in.read();
        if (tag < 0) {
            throw new EOFException("unexpected EOF reading user attribute sub packet");
        }
        byte[] data = new byte[bodyLen - 1];
        this.readFully(data, 0, data.length);
        int type = tag;
        switch (type) {
            case 1: {
                return new ImageAttribute(longLength, data);
            }
        }
        return new UserAttributeSubpacket(type, longLength, data);
    }
}

