/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms.jcajce;

import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.CMSORIforKEMOtherInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.cms.KEMKeyWrapper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.CMSUtils;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.KTSParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.operator.GenericKey;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorException;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.KyberPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.NTRUKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.KyberParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.NTRUParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Integers;

class JceCMSKEMKeyWrapper
extends KEMKeyWrapper {
    private final AlgorithmIdentifier symWrapAlgorithm;
    private final int kekLength;
    private JcaJceExtHelper helper = new DefaultJcaJceExtHelper();
    private Map extraMappings = new HashMap();
    private PublicKey publicKey;
    private SecureRandom random;
    private AlgorithmIdentifier kdfAlgorithm = new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf3, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE));
    private byte[] encapsulation;
    private static Map encLengths = new HashMap();

    public JceCMSKEMKeyWrapper(PublicKey publicKey, ASN1ObjectIdentifier symWrapAlg) {
        super(publicKey instanceof RSAPublicKey ? new AlgorithmIdentifier(ISOIECObjectIdentifiers.id_kem_rsa) : SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()).getAlgorithm());
        this.publicKey = publicKey;
        this.symWrapAlgorithm = new AlgorithmIdentifier(symWrapAlg);
        this.kekLength = CMSUtils.getKekSize(symWrapAlg);
    }

    public JceCMSKEMKeyWrapper setProvider(Provider provider) {
        this.helper = new ProviderJcaJceExtHelper(provider);
        return this;
    }

    public JceCMSKEMKeyWrapper setProvider(String providerName) {
        this.helper = new NamedJcaJceExtHelper(providerName);
        return this;
    }

    public JceCMSKEMKeyWrapper setKDF(AlgorithmIdentifier kdfAlgorithm) {
        this.kdfAlgorithm = kdfAlgorithm;
        return this;
    }

    public JceCMSKEMKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceCMSKEMKeyWrapper setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    @Override
    public byte[] getEncapsulation() {
        return this.encapsulation;
    }

    @Override
    public AlgorithmIdentifier getKdfAlgorithmIdentifier() {
        return this.kdfAlgorithm;
    }

    @Override
    public int getKekLength() {
        return this.kekLength;
    }

    @Override
    public AlgorithmIdentifier getWrapAlgorithmIdentifier() {
        return this.symWrapAlgorithm;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        try {
            byte[] oriInfoEnc = new CMSORIforKEMOtherInfo(this.symWrapAlgorithm, this.kekLength).getEncoded();
            if (this.publicKey instanceof RSAPublicKey) {
                Cipher keyEncryptionCipher = CMSUtils.createAsymmetricWrapper(this.helper, this.getAlgorithmIdentifier().getAlgorithm(), new HashMap());
                try {
                    KTSParameterSpec ktsSpec = new KTSParameterSpec.Builder(CMSUtils.getWrapAlgorithmName(this.symWrapAlgorithm.getAlgorithm()), this.kekLength * 8, oriInfoEnc).withKdfAlgorithm(this.kdfAlgorithm).build();
                    keyEncryptionCipher.init(3, (Key)this.publicKey, ktsSpec, this.random);
                    byte[] encWithKey = keyEncryptionCipher.wrap(CMSUtils.getJceKey(encryptionKey));
                    int modLength = (((RSAPublicKey)this.publicKey).getModulus().bitLength() + 7) / 8;
                    this.encapsulation = Arrays.copyOfRange(encWithKey, 0, modLength);
                    return Arrays.copyOfRange(encWithKey, modLength, encWithKey.length);
                }
                catch (Exception e) {
                    throw new OperatorException("Unable to wrap contents key: " + e.getMessage(), e);
                }
            }
            Cipher keyEncryptionCipher = CMSUtils.createAsymmetricWrapper(this.helper, this.getAlgorithmIdentifier().getAlgorithm(), new HashMap());
            try {
                KTSParameterSpec ktsSpec = new KTSParameterSpec.Builder(CMSUtils.getWrapAlgorithmName(this.symWrapAlgorithm.getAlgorithm()), this.kekLength * 8, oriInfoEnc).withKdfAlgorithm(this.kdfAlgorithm).build();
                keyEncryptionCipher.init(3, (Key)this.publicKey, ktsSpec, this.random);
                byte[] encWithKey = keyEncryptionCipher.wrap(CMSUtils.getJceKey(encryptionKey));
                int encLength = this.getKemEncLength(this.publicKey);
                this.encapsulation = Arrays.copyOfRange(encWithKey, 0, encLength);
                return Arrays.copyOfRange(encWithKey, encLength, encWithKey.length);
            }
            catch (Exception e) {
                throw new OperatorException("Unable to wrap contents key: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new OperatorException("unable to wrap contents key: " + e.getMessage(), e);
        }
    }

    private int getKemEncLength(PublicKey publicKey) {
        if (publicKey instanceof KyberPublicKey) {
            return (Integer)encLengths.get(((KyberPublicKey)publicKey).getParameterSpec().getName());
        }
        if (publicKey instanceof NTRUKey) {
            return (Integer)encLengths.get(((NTRUKey)((Object)publicKey)).getParameterSpec().getName());
        }
        return 0;
    }

    static {
        encLengths.put(KyberParameterSpec.kyber512.getName(), Integers.valueOf(768));
        encLengths.put(KyberParameterSpec.kyber768.getName(), Integers.valueOf(1088));
        encLengths.put(KyberParameterSpec.kyber1024.getName(), Integers.valueOf(1568));
        encLengths.put(NTRUParameterSpec.ntruhps2048509.getName(), Integers.valueOf(699));
        encLengths.put(NTRUParameterSpec.ntruhps2048677.getName(), Integers.valueOf(930));
        encLengths.put(NTRUParameterSpec.ntruhps4096821.getName(), Integers.valueOf(1230));
        encLengths.put(NTRUParameterSpec.ntruhrss701.getName(), Integers.valueOf(1138));
    }
}

