/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jce;

import java.util.Enumeration;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.ec.CustomNamedCurves;
import net.savignano.thirdparty.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        ASN1ObjectIdentifier oid;
        try {
            oid = ECNamedCurveTable.possibleOID(name) ? new ASN1ObjectIdentifier(name) : null;
        }
        catch (IllegalArgumentException e) {
            oid = null;
        }
        X9ECParameters ecP = oid != null ? CustomNamedCurves.getByOID(oid) : CustomNamedCurves.getByName(name);
        if (ecP == null) {
            ecP = oid != null ? net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable.getByOID(oid) : net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable.getByName(name);
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        return net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable.getNames();
    }

    private static boolean possibleOID(String identifier) {
        if (identifier.length() < 3 || identifier.charAt(1) != '.') {
            return false;
        }
        char first = identifier.charAt(0);
        return first >= '0' && first <= '2';
    }
}

