/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntru;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.KEMExtractSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKEMExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKEMGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntru.BCNTRUPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntru.BCNTRUPublicKey;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class NTRUKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int i, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCNTRUPublicKey pubKey = (BCNTRUPublicKey)this.genSpec.getPublicKey();
            NTRUKEMGenerator kemGen = new NTRUKEMGenerator(this.random);
            SecretWithEncapsulation secEnc = kemGen.generateEncapsulated(pubKey.getKeyParams());
            byte[] sharedSecret = secEnc.getSecret();
            byte[] secret = Arrays.copyOfRange(sharedSecret, 0, (this.genSpec.getKeySize() + 7) / 8);
            Arrays.clear(sharedSecret);
            SecretKeyWithEncapsulation rv = new SecretKeyWithEncapsulation(new SecretKeySpec(secret, this.genSpec.getKeyAlgorithmName()), secEnc.getEncapsulation());
            try {
                secEnc.destroy();
            }
            catch (DestroyFailedException e) {
                throw new IllegalStateException("key cleanup failed");
            }
            return rv;
        }
        BCNTRUPrivateKey privKey = (BCNTRUPrivateKey)this.extSpec.getPrivateKey();
        NTRUKEMExtractor kemExt = new NTRUKEMExtractor(privKey.getKeyParams());
        byte[] encapsulation = this.extSpec.getEncapsulation();
        byte[] sharedSecret = kemExt.extractSecret(encapsulation);
        byte[] secret = Arrays.copyOfRange(sharedSecret, 0, (this.extSpec.getKeySize() + 7) / 8);
        Arrays.clear(sharedSecret);
        SecretKeyWithEncapsulation rv = new SecretKeyWithEncapsulation(new SecretKeySpec(secret, this.extSpec.getKeyAlgorithmName()), encapsulation);
        Arrays.clear(secret);
        return rv;
    }
}

