// Display a settings element. Used in admin settings pages.
function displaySettingsElement(element, display) {
	if (display) {
		element.style.display='';
	} else {
		element.style.display='none';
	}
}

// Filter options displayed in select list 
//  filterText: text with which to filter
//  targetId: select element to filter options in
//  baseId: select element holding full base list		
function filterOptions(filterText, targetId, baseId) {
	var lowerFilterText = filterText.toLowerCase();
	var targetElem = document.getElementById(targetId);
	var baseElem = document.getElementById(baseId);

    var selectedValue = targetElem.selectedOptions[0].value
	targetElem.options.length = 0;

	for (var i=0; i < baseElem.options.length; i++) {
		if (baseElem.options[i].value == selectedValue ||
		    baseElem.options[i].value == "" ||
			baseElem.options[i].text.toLowerCase().includes(lowerFilterText)) {
			var optionElem = document.createElement("option");
			optionElem.text = baseElem.options[i].text;
			optionElem.value = baseElem.options[i].value;
			optionElem.selected = (optionElem.value == selectedValue);
			targetElem.appendChild(optionElem);
		}
	}
}