/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.smime.ASmimeKeyLoader;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.util.KeyStoreContentFetcher;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import org.slf4j.Logger;

public class SmimeDecryptionKeyStoreLoader
extends ASmimeKeyLoader<SmimeDecryptionKey, KeyTransRecipientId> {
    public static final int INFO_NO_KEY_STORE = 200;
    private final KeyStore keyStore;
    private final char[] password;

    public SmimeDecryptionKeyStoreLoader(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SmimeDecryptionKey loadInternalKey(KeyTransRecipientId forId) throws Exception {
        Optional<Map.Entry<X509Certificate, PrivateKey>> privateKey;
        if (this.getKeyStore() == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        String keyId = this.getKeyId(forId);
        Logger log = this.getLog();
        log.debug("Looking up private key in key store (size {}) with ID: {}", (Object)this.keyStore.size(), (Object)keyId);
        KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(this.keyStore);
        fetcher.keyPassword(this.password);
        Predicate<X509Certificate> predId = c -> c.getSerialNumber().equals(forId.getSerialNumber()) && SmimeUtil.getIssuer(c).equals(forId.getIssuer());
        Predicate<X509Certificate> predCriticalExtension = this::isCritExtensionSatisfied;
        try {
            privateKey = fetcher.getEntryFor(predId.and(predCriticalExtension));
        }
        finally {
            fetcher.destroy();
        }
        if (!privateKey.isPresent()) {
            log.debug("Found no private key in key store with ID: {}", (Object)keyId);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Found private key in key store with ID: {}", (Object)keyId);
        SmimeDecryptionKey key = new SmimeDecryptionKey(privateKey.get().getValue(), privateKey.get().getKey());
        key.setKeySource(this.getKeySource());
        return key;
    }

    private String getKeyId(KeyTransRecipientId id) {
        return SmimeUtil.getSerialNumber(id.getSerialNumber()) + " from " + id.getIssuer();
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected SmimeDecryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeDecryptionKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        return "SmimeDecryptionKeyStoreLoader [keyStore=" + this.keyStore + ", password=*****]";
    }
}

