/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor.extract;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.mail.visitor.ResultMessageVisitor;
import net.savignano.cryptography.mail.visitor.extract.AMailExtractor;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;

public class PgpMailExtractor
extends AMailExtractor<PgpEncryptionKey> {
    public PgpMailExtractor(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    protected PgpEncryptionKey doExtract(MimeMessage msg, String email) throws Exception {
        ExtractVisitor visitor = new ExtractVisitor();
        visitor.visit(msg);
        PGPPublicKeyRing ring = PgpUtil.getKeysForEmail((PGPPublicKeyRingCollection)visitor.getResult(), email);
        if (ring == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        PgpEncryptionKey key = new PgpEncryptionKey(ring, email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpEncryptionKey(validity, EKeySource.EMAIL);
    }

    protected static final class ExtractVisitor
    extends ResultMessageVisitor<PGPPublicKeyRingCollection> {
        protected ExtractVisitor() {
        }

        @Override
        protected void handlePart(MimePart part) throws Exception {
            ContentType type = new ContentType(part.getContentType());
            this.getLog().trace("MIME type: {}", (Object)type);
            if (type.match("application/pgp-keys") || this.isKeyAttachment(part)) {
                this.getLog().debug("Found PGP keys attached to message with ID: {}", (Object)this.getMsgId());
                PGPPublicKeyRingCollection keys = PgpUtil.loadPublicKeys(part.getInputStream());
                if (this.getResult() == null) {
                    this.setResult(keys);
                } else {
                    for (PGPPublicKeyRing ring : keys) {
                        PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)this.getResult(), ring);
                    }
                }
            }
        }

        private boolean isKeyAttachment(MimePart part) throws MessagingException {
            String fileName;
            String disposition = part.getDisposition();
            return disposition != null && disposition.equalsIgnoreCase("attachment") && (fileName = part.getFileName()) != null && fileName.endsWith(".asc") && !part.isMimeType("application/pgp-encrypted") && !part.isMimeType("application/pgp-signature");
        }
    }
}

