/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.smime.SmimeCertificateKeyStoreLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeEncryptionKeyManager
extends AKeyManager<SmimeEncryptionKey, String> {
    private static final Logger log = LoggerFactory.getLogger(SmimeEncryptionKeyManager.class);
    private static final Map<String, SmimeEncryptionKey> keyCache = new HashMap<String, SmimeEncryptionKey>();
    private static final Map<String, Calendar> timeCache = new HashMap<String, Calendar>();

    public SmimeEncryptionKeyManager(ISnotifyAppProperties appProps) {
        super(appProps);
    }

    @Override
    protected SmimeEncryptionKey getCachedKey(String address) {
        return keyCache.getOrDefault(address, this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN));
    }

    @Override
    protected void setCachedKey(String address, SmimeEncryptionKey key) throws IOException {
        if (key != null) {
            keyCache.put(address, key);
        } else {
            keyCache.remove(address);
        }
        timeCache.put(address, Calendar.getInstance());
    }

    @Override
    protected boolean isCacheAutomaticallyExpired(String address) {
        if (super.isCacheAutomaticallyExpired(address)) {
            return true;
        }
        Calendar cachedTimeStamp = this.getCachedTimeStamp(address);
        if (cachedTimeStamp == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (Calendar.getInstance().get(5) != cachedTimeStamp.get(5)) {
            log.debug("Cache automatically expired: New day.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired(String address) {
        Long expireTimeStamp;
        if (super.isCacheManuallyExpired(address)) {
            return true;
        }
        Calendar cachedTimeStamp = this.getCachedTimeStamp(address);
        if (cachedTimeStamp != null && (expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP)) != null && expireTimeStamp > cachedTimeStamp.getTimeInMillis()) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeEncryptionKey, String>>>>> getKeyLoaders() {
        ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeEncryptionKey, String>>>>> loaders = new ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeEncryptionKey, String>>>>>();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SmimeEncryptionKey, String>> createKeyStoreLoader() {
        String location = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No private key store specified. Can't get decryption from key store.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_SMIME_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_SMIME_KEY_PASSWORD)) {
            log.error("Error retrieving password for S/MIME private key.");
            return Optional.empty();
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", SecurityUtil.getProvider());
            log.debug("Loading key store from location: {}", (Object)location);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, keyPassword);
            }
            SecurityUtil.clearPassword(keyPassword);
            log.debug("Loaded key store from location \"{}\" succesfully.", (Object)location);
            SmimeCertificateKeyStoreLoader loader = new SmimeCertificateKeyStoreLoader(ks);
            loader.setIgnoreCriticalExtension(!this.getAppProps().getBoolean(EProperty.TWEAK_SMIME_STRICT_CERTIFICATE_CHECKING));
            return Optional.of(loader);
        }
        catch (Exception e) {
            log.error("Could not load key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SmimeEncryptionKey(validity, keySource);
    }

    protected Calendar getCachedTimeStamp(String address) {
        return timeCache.get(address);
    }

    protected void setCachedTimeStamp(String address, Calendar cachedTimeStamp) {
        timeCache.put(address, cachedTimeStamp);
    }
}

