/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.common;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import net.savignano.snotify.atlassian.common.properties.ASnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class SnotifyUserProperties
extends ASnotifyUserProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserProperties.class);
    private static Method googleUpdateMethod = SnotifyUserProperties.getGoogleMethod();
    @Autowired
    @ComponentImport
    private UserSettingsService userSettingsService;
    @Autowired
    @ComponentImport
    private SecurityService securityService;

    private static Method getGoogleMethod() {
        for (Method method : UserSettingsService.class.getDeclaredMethods()) {
            Parameter[] parameters;
            if (method.getParameterCount() != 2 || !method.getName().equals("updateUserSettings") || !(parameters = method.getParameters())[0].getType().getName().equals("com.atlassian.sal.api.user.UserKey") || !parameters[1].getType().getName().equals("com.google.common.base.Function")) continue;
            log.debug("Found deprecated Google method to set user settings. Must be Bitbucket version < 9");
            return method;
        }
        log.debug("Did not find deprecated Google method. Must be Bitbucket version >= 9.0");
        return null;
    }

    @Override
    protected String get(String key, IUser<?> user) throws Exception {
        return (String)this.getProps(user, key).getOrNull();
    }

    @Override
    protected void set(String key, String value, IUser<?> user) throws Exception {
        this.updateProps(user, b -> b.put(key, value).build());
    }

    @Override
    protected void remove(String key, IUser<?> user) throws Exception {
        this.updateProps(user, b -> b.remove(key).build());
    }

    private UserSettingsService getUserSettingsService() {
        if (this.userSettingsService == null) {
            log.trace("Injection of UserSettingsService failed. Loading manually.");
            this.userSettingsService = (UserSettingsService)ComponentLocator.getComponent(UserSettingsService.class);
        }
        return this.userSettingsService;
    }

    private SecurityService getSecurityService() {
        if (this.securityService == null) {
            log.trace("Injection of SecurityService failed. Loading manually.");
            this.securityService = (SecurityService)ComponentLocator.getComponent(SecurityService.class);
        }
        return this.securityService;
    }

    private Option<String> getProps(IUser<?> user, String key) {
        BitbucketUser bbUser = this.toBitbucketUser(user);
        EscalatedSecurityContext context = this.getSecurityService().impersonating(bbUser.getActualUser(), "Getting user properties for: " + String.valueOf(bbUser));
        UserKey userKey = this.getUserKey(bbUser);
        UncheckedOperation operation = () -> this.getUserSettingsService().getUserSettings(userKey).getString(key);
        return (Option)context.call((Operation)operation);
    }

    private void updateProps(IUser<?> user, java.util.function.Function<UserSettingsBuilder, UserSettings> update) {
        BitbucketUser bbUser = this.toBitbucketUser(user);
        EscalatedSecurityContext context = this.getSecurityService().impersonating(bbUser.getActualUser(), "Setting user properties for: " + String.valueOf(bbUser));
        UserKey userKey = this.getUserKey(bbUser);
        UncheckedOperation operation = googleUpdateMethod != null ? () -> {
            this.invokeGoogleMethod(userKey, update);
            return null;
        } : () -> {
            this.getUserSettingsService().updateUserSettings(userKey, update);
            return null;
        };
        context.call((Operation)operation);
    }

    private void invokeGoogleMethod(UserKey userKey, final java.util.function.Function<UserSettingsBuilder, UserSettings> function) {
        log.debug("Invoking deprecated Google method to set user settings.");
        try {
            googleUpdateMethod.invoke((Object)this.getUserSettingsService(), userKey, new Function<UserSettingsBuilder, UserSettings>(){

                public UserSettings apply(UserSettingsBuilder input) {
                    return (UserSettings)function.apply(input);
                }
            });
        }
        catch (Exception e) {
            log.error("Could not update user property for user with key \"" + String.valueOf(userKey) + "\". Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private UserKey getUserKey(BitbucketUser user) {
        return UserKey.fromLong((long)user.getActualUser().getId());
    }

    private BitbucketUser toBitbucketUser(IUser<?> user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't get user preferences for 'null' user.");
        }
        if (!(user instanceof BitbucketUser)) {
            throw new IllegalArgumentException("User is not a BitbucketUser. Found instead: " + String.valueOf(user));
        }
        return (BitbucketUser)user;
    }
}

