/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetStringParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1SequenceParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1SetParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AttributeTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AuthenticatedDataParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.CMSAttributes;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfoParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.OriginatorInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSContentInfoParser;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEnvelopedHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSProcessableInputStream;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSecureReadable;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSUtils;
import net.savignano.thirdparty.org.bouncycastle.cms.OriginatorInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformationStore;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class CMSAuthenticatedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore recipientInfoStore;
    AuthenticatedDataParser authData = new AuthenticatedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier macAlg;
    private byte[] mac;
    private AttributeTable authAttrs;
    private ASN1Set authAttrSet;
    private AttributeTable unauthAttrs;
    private boolean authAttrNotRead = true;
    private boolean unauthAttrNotRead;
    private OriginatorInformation originatorInfo;
    private CMSSecureReadable secureReadable;

    public CMSAuthenticatedDataParser(byte[] envelopedData) throws CMSException, IOException {
        this(new ByteArrayInputStream(envelopedData));
    }

    public CMSAuthenticatedDataParser(byte[] envelopedData, DigestCalculatorProvider digestCalculatorProvider) throws CMSException, IOException {
        this(new ByteArrayInputStream(envelopedData), digestCalculatorProvider);
    }

    public CMSAuthenticatedDataParser(InputStream envelopedData) throws CMSException, IOException {
        this(envelopedData, null);
    }

    public CMSAuthenticatedDataParser(InputStream envelopedData, DigestCalculatorProvider digestCalculatorProvider) throws CMSException, IOException {
        super(envelopedData);
        OriginatorInfo info = this.authData.getOriginatorInfo();
        if (info != null) {
            this.originatorInfo = new OriginatorInformation(info);
        }
        ASN1Set recipientInfos = ASN1Set.getInstance(this.authData.getRecipientInfos().toASN1Primitive());
        this.macAlg = this.authData.getMacAlgorithm();
        AlgorithmIdentifier digestAlgorithm = this.authData.getDigestAlgorithm();
        if (digestAlgorithm != null) {
            if (digestCalculatorProvider == null) {
                throw new CMSException("a digest calculator provider is required if authenticated attributes are present");
            }
            ContentInfoParser data = this.authData.getEncapsulatedContentInfo();
            CMSProcessableInputStream readable = new CMSProcessableInputStream(((ASN1OctetStringParser)data.getContent(4)).getOctetStream());
            try {
                this.secureReadable = new CMSEnvelopedHelper.CMSDigestAuthenticatedSecureReadable(digestCalculatorProvider.get(digestAlgorithm), data.getContentType(), readable);
                this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.macAlg, this.secureReadable);
            }
            catch (OperatorCreationException e) {
                throw new CMSException("unable to create digest calculator: " + e.getMessage(), e);
            }
        } else {
            ContentInfoParser data = this.authData.getEncapsulatedContentInfo();
            CMSProcessableInputStream readable = new CMSProcessableInputStream(((ASN1OctetStringParser)data.getContent(4)).getOctetStream());
            this.secureReadable = new CMSEnvelopedHelper.CMSAuthEnveSecureReadable(this.macAlg, data.getContentType(), readable);
            this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.macAlg, this.secureReadable);
        }
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.originatorInfo;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.macAlg;
    }

    public String getMacAlgOID() {
        return this.macAlg.getAlgorithm().toString();
    }

    public byte[] getMacAlgParams() {
        try {
            return CMSUtils.encodeObj(this.macAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public byte[] getMac() throws IOException {
        if (this.mac == null) {
            this.getAuthAttrs();
            this.mac = this.authData.getMac().getOctets();
        }
        return Arrays.clone(this.mac);
    }

    private ASN1Set getAuthAttrSet() throws IOException {
        if (this.authAttrs == null && this.authAttrNotRead) {
            ASN1SetParser set = this.authData.getAuthAttrs();
            if (set != null) {
                this.authAttrSet = (ASN1Set)set.toASN1Primitive();
            }
            this.authAttrNotRead = false;
            this.secureReadable.setAuthAttrSet(this.authAttrSet);
        }
        return this.authAttrSet;
    }

    public AttributeTable getAuthAttrs() throws IOException {
        ASN1Set set;
        if (this.authAttrs == null && this.authAttrNotRead && (set = this.getAuthAttrSet()) != null) {
            this.authAttrs = new AttributeTable(set);
        }
        return this.authAttrs;
    }

    public AttributeTable getUnauthAttrs() throws IOException {
        if (this.unauthAttrs == null && this.unauthAttrNotRead) {
            this.unauthAttrNotRead = false;
            this.unauthAttrs = CMSUtils.getAttributesTable(this.authData.getUnauthAttrs());
        }
        return this.unauthAttrs;
    }

    public byte[] getContentDigest() {
        if (this.authAttrs != null) {
            return ASN1OctetString.getInstance(this.authAttrs.get(CMSAttributes.messageDigest).getAttrValues().getObjectAt(0)).getOctets();
        }
        return null;
    }
}

