/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.drbg;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.drbg.IncrementalEntropySource;
import net.savignano.thirdparty.org.bouncycastle.util.Properties;

class EntropyGatherer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(EntropyGatherer.class.getName());
    private final long pause;
    private final AtomicBoolean seedAvailable;
    private final AtomicReference<byte[]> entropy;
    private final IncrementalEntropySource baseRandom;

    EntropyGatherer(IncrementalEntropySource baseRandom, AtomicBoolean seedAvailable, AtomicReference<byte[]> entropy) {
        this.baseRandom = baseRandom;
        this.seedAvailable = seedAvailable;
        this.entropy = entropy;
        this.pause = EntropyGatherer.getPause();
    }

    @Override
    public void run() {
        try {
            this.entropy.set(this.baseRandom.getEntropy(this.pause));
            this.seedAvailable.set(true);
        }
        catch (InterruptedException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("entropy request interrupted - exiting");
            }
            Thread.currentThread().interrupt();
        }
    }

    private static long getPause() {
        String pauseSetting = Properties.getPropertyValue("net.savignano.thirdparty.org.bouncycastle.drbg.gather_pause_secs");
        if (pauseSetting != null) {
            try {
                return Long.parseLong(pauseSetting) * 1000L;
            }
            catch (Exception e) {
                return 5000L;
            }
        }
        return 5000L;
    }
}

